/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.IOException;
import java.io.Reader;
import polyglot.ast.Node;
import polyglot.frontend.AbstractPass;
import polyglot.frontend.Compiler;
import polyglot.frontend.FileSource;
import polyglot.frontend.Parser;
import polyglot.frontend.goals.Goal;
import polyglot.main.Report;
import polyglot.util.ErrorQueue;
import polyglot.util.Position;

public class ParserPass
extends AbstractPass {
    protected Compiler compiler;

    public ParserPass(Compiler compiler, Goal goal) {
        super(goal);
        this.compiler = compiler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean run() {
        ErrorQueue eq = this.compiler.errorQueue();
        FileSource source = (FileSource)this.goal.job().source();
        try (Reader reader = source.openReader(false);){
            Node ast;
            Parser p = this.goal.job().extensionInfo().parser(reader, source, eq);
            if (Report.should_report("frontend", 2)) {
                Report.report(2, "Using parser " + p);
            }
            if ((ast = p.parse()) != null) {
                this.goal.job().ast(ast);
                boolean bl2 = true;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            eq.enqueue(2, e.getMessage(), new Position(this.goal.job().source().path(), this.goal.job().source().name(), 1, 1, 1, 1));
            return false;
        }
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.goal.job().source() + ")";
    }
}

