/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.filemanager.ExtFileManager;
import polyglot.filemanager.FileManager;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileSource;
import polyglot.frontend.Job;
import polyglot.frontend.JobExt;
import polyglot.frontend.Parser;
import polyglot.frontend.Scheduler;
import polyglot.frontend.Source;
import polyglot.frontend.SourceLoader;
import polyglot.frontend.Source_c;
import polyglot.frontend.Stats;
import polyglot.frontend.TargetFactory;
import polyglot.frontend.goals.Goal;
import polyglot.main.Options;
import polyglot.main.Version;
import polyglot.translate.ext.ToExt;
import polyglot.translate.ext.ToExt_c;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLoader;
import polyglot.types.reflect.ClassFile_c;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;

public abstract class AbstractExtensionInfo
implements ExtensionInfo {
    protected Compiler compiler;
    private Options options;
    protected TypeSystem ts = null;
    protected NodeFactory nf = null;
    protected TargetFactory target_factory = null;
    protected Stats stats;
    protected Scheduler scheduler;
    protected FileManager extFM;
    protected ClassFileLoader classFileLoader;
    protected List<JavaFileManager.Location> default_locations;

    @Override
    public abstract Goal getCompileGoal(Job var1);

    @Override
    public abstract String compilerName();

    @Override
    public abstract String defaultFileExtension();

    @Override
    public abstract Version version();

    @Override
    public Options getOptions() {
        if (this.options == null) {
            this.options = this.createOptions();
        }
        return this.options;
    }

    protected Options createOptions() {
        return new Options(this);
    }

    @Override
    public Stats getStats() {
        if (this.stats == null) {
            this.stats = new Stats(this);
        }
        return this.stats;
    }

    @Override
    public Compiler compiler() {
        return this.compiler;
    }

    @Override
    public void initCompiler(Compiler compiler) {
        this.compiler = compiler;
        compiler.addExtension(this);
        if (this.outputExtensionInfo() != null) {
            this.outputExtensionInfo().initCompiler(compiler);
        }
        this.typeSystem();
        this.nodeFactory();
        this.scheduler();
        this.initTypeSystem();
    }

    protected abstract void initTypeSystem();

    @Override
    public String[] fileExtensions() {
        String[] sx;
        String[] stringArray = sx = this.getOptions() == null ? null : this.getOptions().source_ext;
        if (sx == null) {
            sx = this.defaultFileExtensions();
        }
        if (sx.length == 0) {
            return this.defaultFileExtensions();
        }
        return sx;
    }

    @Override
    public String[] defaultFileExtensions() {
        String ext = this.defaultFileExtension();
        return new String[]{ext};
    }

    @Override
    public SourceLoader sourceLoader() {
        return this.extFileManager();
    }

    @Override
    public TargetFactory targetFactory() {
        if (this.target_factory == null) {
            this.target_factory = new TargetFactory(this.extFileManager(), this.getOptions().source_output, this.getOptions().output_ext, this.getOptions().output_stdout);
        }
        return this.target_factory;
    }

    protected abstract Scheduler createScheduler();

    @Override
    public Scheduler scheduler() {
        if (this.scheduler == null) {
            this.scheduler = this.createScheduler();
        }
        return this.scheduler;
    }

    protected abstract TypeSystem createTypeSystem();

    @Override
    public TypeSystem typeSystem() {
        if (this.ts == null) {
            this.ts = this.createTypeSystem();
        }
        return this.ts;
    }

    protected abstract NodeFactory createNodeFactory();

    @Override
    public NodeFactory nodeFactory() {
        if (this.nf == null) {
            this.nf = this.createNodeFactory();
        }
        return this.nf;
    }

    @Override
    public JobExt jobExt() {
        return null;
    }

    @Override
    public abstract Parser parser(Reader var1, FileSource var2, ErrorQueue var3);

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public ClassFile createClassFile(FileObject f, byte[] code) throws IOException {
        return new ClassFile_c(f, code, this);
    }

    @Override
    @Deprecated
    public FileSource createFileSource(FileObject f, boolean user) throws IOException {
        return this.createFileSource(f, user ? Source.Kind.USER_SPECIFIED : Source.Kind.DEPENDENCY);
    }

    @Override
    public FileSource createFileSource(FileObject fo, Source.Kind kind) throws IOException {
        return new Source_c(fo, kind);
    }

    @Override
    public FileManager extFileManager() {
        if (this.extFM == null) {
            this.extFM = this.createFileManager();
            try {
                this.configureFileManager();
            }
            catch (IOException e) {
                throw new InternalCompilerError(e);
            }
        }
        return this.extFM;
    }

    protected FileManager createFileManager() {
        return new ExtFileManager(this);
    }

    protected void configureFileManager() throws IOException {
        Options opt = this.getOptions();
        this.extFM.setLocation(opt.source_path, opt.sourcepath_directories);
        this.extFM.setLocation(opt.source_output, Collections.singleton(opt.sourceOutputDirectory()));
        this.extFM.setLocation(opt.class_output, Collections.singleton(opt.classOutputDirectory()));
        this.extFM.setLocation(opt.bootclasspath, opt.bootclasspathDirectories());
        this.extFM.setLocation(opt.classpath, opt.classpathDirectories());
    }

    @Override
    public void configureFileManagerForPostCompiler() throws IOException {
        Options opt = this.getOptions();
        this.extFM.setLocation(StandardLocation.PLATFORM_CLASS_PATH, opt.defaultPlatformClasspath());
        List<File> sourcepath = Collections.singletonList(opt.sourceOutputDirectory());
        this.extFM.setLocation(StandardLocation.SOURCE_PATH, sourcepath);
        ArrayList<File> classpath = new ArrayList<File>();
        classpath.addAll(opt.bootclasspathDirectories());
        classpath.addAll(opt.classpathDirectories());
        this.extFM.setLocation(StandardLocation.CLASS_PATH, classpath);
        List<File> classout = Collections.singletonList(opt.classOutputDirectory());
        this.extFM.setLocation(StandardLocation.CLASS_OUTPUT, classout);
    }

    @Override
    public ClassFileLoader classFileLoader() {
        if (this.classFileLoader == null) {
            this.classFileLoader = this.extFileManager();
        }
        return this.classFileLoader;
    }

    @Override
    public ToExt getToExt(ExtensionInfo to_ext, Node n) {
        return ToExt_c.ext(n);
    }

    @Override
    public ExtensionInfo outputExtensionInfo() {
        return null;
    }

    @Override
    public void cleanup() {
        this.compiler().outputFiles().clear();
        this.ts = null;
    }

    @Override
    public List<JavaFileManager.Location> defaultLocations() {
        if (this.default_locations == null) {
            this.default_locations = new ArrayList<JavaFileManager.Location>();
            this.default_locations.add(this.getOptions().bootclasspath);
            this.default_locations.add(this.getOptions().classpath);
        }
        return this.default_locations;
    }
}

