/*
 * Decompiled with CFR 0.152.
 */
package polyglot.filemanager;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import polyglot.filemanager.ExtFileObject;
import polyglot.filemanager.FileManager;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileSource;
import polyglot.frontend.Source;
import polyglot.main.Main;
import polyglot.main.Report;
import polyglot.types.reflect.ClassFile;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;

public class ExtFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager>
implements FileManager {
    protected static final JavaCompiler javaCompiler = Main.javaCompiler();
    protected final ExtensionInfo extInfo;
    protected final Map<String, FileSource> loadedSources;
    protected static final Map<String, Boolean> packageCache = new HashMap<String, Boolean>();
    protected static final Set<String> nocache = new HashSet<String>();
    protected static final Map<File, Object> zipCache = new HashMap<File, Object>();
    protected static final Object not_found = new Object();
    protected static final int BUF_SIZE = 8192;
    protected static final Collection<String> report_topics = CollectionUtil.list("types", "resolver", "loader");
    protected static final Set<JavaFileObject.Kind> ALL_KINDS = new HashSet<JavaFileObject.Kind>();
    protected final Map<JavaFileManager.Location, Map<String, JavaFileObject>> objectMap;
    protected int caseInsensitive;
    protected boolean caseInsensitivityComputed;
    protected final boolean inMemory;
    protected static List<JavaFileManager.Location> default_locations;
    protected static Collection<String> verbose;

    public ExtFileManager(ExtensionInfo extInfo) {
        super(javaCompiler.getStandardFileManager(null, null, null));
        this.extInfo = extInfo;
        this.loadedSources = new HashMap<String, FileSource>();
        this.objectMap = new HashMap<JavaFileManager.Location, Map<String, JavaFileObject>>();
        this.inMemory = extInfo.getOptions().noOutputToFS;
        List<JavaFileManager.Location> defaultLocations = extInfo.defaultLocations();
        if (!defaultLocations.equals(default_locations)) {
            default_locations = defaultLocations;
            this.clearCache();
        }
    }

    protected void clearCache() {
        packageCache.clear();
        nocache.clear();
        zipCache.clear();
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        String key;
        JavaFileObject jfo;
        Map<String, JavaFileObject> locMap;
        if (this.inMemory && (locMap = this.objectMap.get(location)) != null && (jfo = locMap.get(key = this.fileKey(packageName, relativeName))) != null) {
            return jfo;
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        String pkg = StringUtil.getPackageComponent(className);
        String name = StringUtil.getShortNameComponent(className);
        String relativeName = name + kind.extension;
        return (JavaFileObject)this.getFileForInput(location, pkg, relativeName);
    }

    protected JavaFileObject.Kind kindFromExtension(String name) {
        JavaFileObject.Kind k = name.endsWith(".java") ? JavaFileObject.Kind.SOURCE : (name.endsWith(".class") ? JavaFileObject.Kind.CLASS : (name.endsWith(".html") || name.endsWith(".htm") ? JavaFileObject.Kind.HTML : JavaFileObject.Kind.OTHER));
        return k;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        if (this.inMemory) {
            String key = this.fileKey(packageName, relativeName);
            URI src = URI.create("file:///" + key);
            ExtFileObject jfo = new ExtFileObject(src, this.kindFromExtension(relativeName));
            Map<String, JavaFileObject> locMap = this.objectMap.get(location);
            if (locMap == null) {
                locMap = new HashMap<String, JavaFileObject>();
                this.objectMap.put(location, locMap);
            }
            locMap.put(key, jfo);
            return jfo;
        }
        return super.getFileForOutput(location, packageName, relativeName, sibling);
    }

    protected String fileKey(String packageName, String relativeName) {
        if (!packageName.isEmpty()) {
            packageName = packageName.replace('.', File.separatorChar) + File.separatorChar;
        }
        StringBuilder sb = new StringBuilder(packageName);
        sb.append(relativeName);
        return sb.toString();
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        String pkg = StringUtil.getPackageComponent(className);
        String name = StringUtil.getShortNameComponent(className);
        String relativeName = name + kind.extension;
        return (JavaFileObject)this.getFileForOutput(location, pkg, relativeName, sibling);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.objectMap.get(location) != null || super.hasLocation(location);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof ExtFileObject) {
            String className = ((ExtFileObject)file).getName();
            return className.substring(className.lastIndexOf(46) + 1);
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Map<String, JavaFileObject> locMap = this.objectMap.get(location);
        if (locMap != null) {
            return locMap.values();
        }
        return super.list(location, packageName, kinds, recurse);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjects(files);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjects(names);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromFiles(files);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromStrings(names);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        return ((StandardJavaFileManager)this.fileManager).getLocation(location);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a.toUri().equals(b.toUri());
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> path) throws IOException {
        ((StandardJavaFileManager)this.fileManager).setLocation(location, path);
    }

    @Override
    public boolean packageExists(String name) {
        if (packageCache.containsKey(name)) {
            return packageCache.get(name);
        }
        boolean exists = false;
        for (int i = default_locations.size() - 1; !exists && i >= 0; --i) {
            exists = this.packageExists(default_locations.get(i), name);
        }
        if (!exists) {
            exists = this.packageExists(this.extInfo.getOptions().source_path, name);
        }
        packageCache.put(name, exists);
        return exists;
    }

    protected static ZipFile loadZip(File dir) throws IOException {
        Object o = zipCache.get(dir);
        if (o != not_found) {
            ZipFile zip = (ZipFile)o;
            if (zip != null) {
                return zip;
            }
            if (!dir.exists()) {
                zipCache.put(dir, not_found);
            } else {
                if (Report.should_report(verbose, 2)) {
                    Report.report(2, "Opening zip " + dir);
                }
                zip = dir.getName().endsWith(".jar") ? new JarFile(dir) : new ZipFile(dir);
                zipCache.put(dir, zip);
                Enumeration<? extends ZipEntry> i = zip.entries();
                while (i.hasMoreElements()) {
                    ZipEntry ei = i.nextElement();
                    String n = ei.getName();
                    int index = n.indexOf(47);
                    while (index >= 0) {
                        packageCache.put(n.substring(0, index), true);
                        index = n.indexOf(47, index + 1);
                    }
                }
                return zip;
            }
        }
        return null;
    }

    @Override
    public boolean packageExists(JavaFileManager.Location location, String name) {
        Iterable<? extends File> files = this.getLocation(location);
        if (files == null) {
            return false;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
                String entryName = name.replace('.', '/');
                try {
                    ExtFileManager.loadZip(file);
                }
                catch (IOException e) {
                    throw new InternalCompilerError(e);
                }
                Boolean contains = packageCache.get(entryName);
                if (contains == null || !contains.booleanValue()) continue;
                return true;
            }
            String filePath = name.replace('.', File.separatorChar);
            File newFile = new File(file, filePath);
            try {
                if (!newFile.exists() || !newFile.isDirectory() || !newFile.getCanonicalPath().endsWith(filePath)) continue;
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public ClassFile loadFile(String name) {
        if (nocache.contains(name)) {
            return null;
        }
        ClassFile clazz = null;
        for (int i = default_locations.size() - 1; i >= 0 && (clazz = this.loadFile(default_locations.get(i), name)) == null; --i) {
        }
        if (clazz == null) {
            nocache.add(name);
        }
        return clazz;
    }

    @Override
    public ClassFile loadFile(JavaFileManager.Location location, String name) {
        block13: {
            if (Report.should_report(report_topics, 3)) {
                Report.report(3, "looking in " + location + " for " + name);
            }
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Location " + location + " has " + this.getLocation(location));
            }
            try {
                JavaFileObject jfo = null;
                try {
                    jfo = this.getJavaFileForInput(location, name, JavaFileObject.Kind.CLASS);
                }
                catch (IOException e) {
                    throw new InternalCompilerError("Error while checking for class file " + name, e);
                }
                if (jfo != null) {
                    if (Report.should_report(report_topics, 4)) {
                        Report.report(4, "Class " + name + " found in " + location + " at " + jfo.toUri());
                    }
                } else if (Report.should_report(report_topics, 4)) {
                    Report.report(4, "Class " + name + " not found in " + location);
                }
                if (jfo != null) {
                    return this.extInfo.createClassFile(jfo, ExtFileManager.getBytes(jfo));
                }
            }
            catch (ClassFormatError e) {
                if (Report.should_report(report_topics, 4)) {
                    Report.report(4, "Class " + name + " format error");
                }
            }
            catch (IOException e) {
                if (!Report.should_report(report_topics, 4)) break block13;
                Report.report(4, "Error loading class " + name);
            }
        }
        return null;
    }

    @Override
    public FileSource fileSource(String fileName) throws IOException {
        return this.fileSource(this.extInfo.getOptions().source_path, fileName, Source.Kind.DEPENDENCY);
    }

    @Override
    @Deprecated
    public FileSource fileSource(String fileName, boolean userSpecified) throws IOException {
        return this.fileSource(fileName, userSpecified ? Source.Kind.USER_SPECIFIED : Source.Kind.DEPENDENCY);
    }

    @Override
    public FileSource fileSource(String fileName, Source.Kind kind) throws IOException {
        return this.fileSource(this.extInfo.getOptions().source_path, fileName, kind);
    }

    @Override
    public FileSource fileSource(JavaFileManager.Location location, String fileName) throws IOException {
        return this.fileSource(location, fileName, Source.Kind.DEPENDENCY);
    }

    @Override
    @Deprecated
    public FileSource fileSource(JavaFileManager.Location location, String fileName, boolean userSpecified) throws IOException {
        return this.fileSource(location, fileName, userSpecified ? Source.Kind.USER_SPECIFIED : Source.Kind.DEPENDENCY);
    }

    @Override
    public FileSource fileSource(JavaFileManager.Location location, String fileName, Source.Kind kind) throws IOException {
        boolean bl;
        FileSource sourceFile;
        String key;
        File f = new File(fileName);
        FileObject fo = null;
        if (kind == Source.Kind.USER_SPECIFIED) {
            key = fileName;
            f = f.getAbsoluteFile();
            sourceFile = this.loadedSources.get(key);
            if (sourceFile != null) {
                return sourceFile;
            }
            for (FileObject fileObject : ((StandardJavaFileManager)this.fileManager).getJavaFileObjects(f)) {
                if (fo != null) {
                    throw new InternalCompilerError("Two files exist of the same name");
                }
                fo = fileObject;
            }
        } else {
            if (f.isAbsolute()) {
                throw new InternalCompilerError("Expected relative filename");
            }
            key = this.fileKey(location, "", fileName);
            sourceFile = this.loadedSources.get(key);
            if (sourceFile != null) {
                return sourceFile;
            }
            fo = this.getFileForInput(location, "", fileName);
            if (fo == null) {
                throw new FileNotFoundException("File: " + fileName + " not found.");
            }
        }
        sourceFile = this.extInfo.createFileSource(fo, kind);
        String[] exts = this.extInfo.fileExtensions();
        boolean bl2 = false;
        for (String ext : exts) {
            if (!fileName.endsWith("." + ext)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            String extString = "";
            for (int i = 0; i < exts.length; ++i) {
                if (exts.length == 2 && i == exts.length - 1) {
                    extString = extString + " or ";
                } else if (exts.length != 1 && i == exts.length - 1) {
                    extString = extString + ", or ";
                } else if (i != 0) {
                    extString = extString + ", ";
                }
                extString = extString + "\"." + exts[i] + "\"";
            }
            if (exts.length == 1) {
                throw new IOException("Source \"" + fileName + "\" does not have the extension " + extString + ".");
            }
            throw new IOException("Source \"" + fileName + "\" does not have any of the extensions " + extString + ".");
        }
        if (Report.should_report("loader", 2)) {
            Report.report(2, "Loading class from " + sourceFile);
        }
        if (sourceFile != null) {
            sourceFile.setKind(kind);
            this.loadedSources.put(key, sourceFile);
        }
        return sourceFile;
    }

    @Override
    public FileSource classSource(String className) {
        return this.classSource(this.extInfo.getOptions().source_path, className);
    }

    @Override
    public FileSource classSource(JavaFileManager.Location location, String className) {
        String name = className;
        boolean done = false;
        while (!done) {
            FileSource source = this.checkForSource(location, name);
            if (source != null) {
                return source;
            }
            int dot = name.lastIndexOf(46);
            if (dot == -1) {
                done = true;
                continue;
            }
            name = name.substring(0, dot);
        }
        return null;
    }

    protected FileSource checkForSource(JavaFileManager.Location location, String className) {
        String[] exts;
        for (String ext : exts = this.extInfo.fileExtensions()) {
            FileObject fo;
            String shortName;
            String fileName;
            String pkgName = StringUtil.getPackageComponent(className);
            String key = this.fileKey(location, pkgName, fileName = (shortName = StringUtil.getShortNameComponent(className)) + "." + ext);
            FileSource source = this.loadedSources.get(key);
            if (source != null) {
                return source;
            }
            try {
                fo = this.getFileForInput(location, pkgName, fileName);
            }
            catch (IOException e1) {
                return null;
            }
            if (fo == null) continue;
            try {
                source = this.extInfo.createFileSource(fo, Source.Kind.DEPENDENCY);
                if (Report.should_report("loader", 2)) {
                    Report.report(2, "Loading " + className + " from " + source);
                }
                this.loadedSources.put(key, source);
                return source;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected String fileKey(JavaFileManager.Location location, String packageName, String fileName) {
        if (this.caseInsensitive()) {
            return location + "/" + packageName.toLowerCase() + "/" + fileName.toLowerCase();
        }
        return location + "/" + packageName + "/" + fileName;
    }

    @Override
    public boolean caseInsensitive() {
        if (!this.caseInsensitivityComputed) {
            this.setCaseInsensitive(System.getProperty("user.dir"));
            if (this.caseInsensitive == 0) {
                throw new InternalCompilerError("unknown case sensitivity");
            }
            this.caseInsensitivityComputed = true;
        }
        return this.caseInsensitive == 1;
    }

    private void setCaseInsensitive(String fileName) {
        File f2;
        if (this.caseInsensitive != 0) {
            return;
        }
        File f1 = new File(fileName.toUpperCase());
        if (f1.equals(f2 = new File(fileName.toLowerCase()))) {
            this.caseInsensitive = 1;
        } else if (f1.exists() && f2.exists()) {
            boolean f1Exists = false;
            boolean f2Exists = false;
            File dir = f1.getParent() != null ? new File(f1.getParent()) : new File(fileName);
            File[] ls = dir.listFiles();
            if (ls != null) {
                for (File element : ls) {
                    if (f1.equals(element)) {
                        f1Exists = true;
                    }
                    if (!f2.equals(element)) continue;
                    f2Exists = true;
                }
            }
            this.caseInsensitive = !f1Exists || !f2Exists ? 1 : -1;
        } else {
            this.caseInsensitive = -1;
        }
    }

    public static byte[] getBytes(FileObject fo) throws IOException {
        int nRead;
        InputStream is = fo.openInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[2048];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    static {
        ALL_KINDS.add(JavaFileObject.Kind.CLASS);
        ALL_KINDS.add(JavaFileObject.Kind.SOURCE);
        ALL_KINDS.add(JavaFileObject.Kind.HTML);
        ALL_KINDS.add(JavaFileObject.Kind.OTHER);
        verbose = new HashSet<String>();
        verbose.add("filemanager");
    }
}

