/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.param.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import polyglot.ext.param.types.MuPClass;
import polyglot.ext.param.types.PClass;
import polyglot.ext.param.types.Param;
import polyglot.ext.param.types.ParamTypeSystem;
import polyglot.ext.param.types.Subst;
import polyglot.ext.param.types.SubstClassType_c;
import polyglot.ext.param.types.SubstType;
import polyglot.main.Report;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.util.CachingTransformingList;
import polyglot.util.SerialVersionUID;
import polyglot.util.Transformation;
import polyglot.util.TypeInputStream;

public class Subst_c<Formal extends Param, Actual extends TypeObject>
implements Subst<Formal, Actual> {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Map<Formal, Actual> subst;
    protected transient Map<CacheTypeWrapper, Type> cache;
    protected transient Map<ClassType, ClassType> substClassTypeCache;
    protected transient ParamTypeSystem<Formal, Actual> ts;
    private static final long writeObjectVersionUID = 1L;
    private static final long readObjectVersionUID = 1L;

    public Subst_c(ParamTypeSystem<Formal, Actual> ts, Map<Formal, ? extends Actual> subst) {
        this.ts = ts;
        this.subst = new HashMap<Formal, Actual>(subst);
        this.cache = new HashMap<CacheTypeWrapper, Type>();
        this.substClassTypeCache = new HashMap<ClassType, ClassType>();
    }

    @Override
    public ParamTypeSystem<Formal, Actual> typeSystem() {
        return this.ts;
    }

    @Override
    public Iterator<Map.Entry<Formal, Actual>> entries() {
        return this.substitutions().entrySet().iterator();
    }

    @Override
    public Iterable<Map.Entry<Formal, Actual>> is_entry() {
        return new Iterable<Map.Entry<Formal, Actual>>(){

            @Override
            public Iterator<Map.Entry<Formal, Actual>> iterator() {
                return Subst_c.this.entries();
            }
        };
    }

    @Override
    public Map<Formal, Actual> substitutions() {
        return Collections.unmodifiableMap(this.subst);
    }

    protected Type uncachedSubstType(Type t) {
        if (t.isArray()) {
            ArrayType at = t.toArray();
            return at.base(this.substType(at.base()));
        }
        if (t instanceof SubstType) {
            SubstType substType = (SubstType)t;
            Type tbase = substType.base();
            Map tsubst = substType.subst().substitutions();
            HashMap<Param, TypeObject> newSubst = new HashMap<Param, TypeObject>();
            for (Map.Entry e : tsubst.entrySet()) {
                Param formal = (Param)e.getKey();
                TypeObject actual = (TypeObject)e.getValue();
                newSubst.put(formal, this.substSubstValue(actual));
            }
            return this.ts.subst(tbase, newSubst);
        }
        if (t instanceof ClassType) {
            return this.substClassType((ClassType)t);
        }
        return t;
    }

    protected Actual substSubstValue(Actual value) {
        return value;
    }

    public final ClassType substClassType(ClassType t) {
        ClassType substct = this.substClassTypeCache.get(t);
        if (substct == null) {
            substct = this.substClassTypeImpl(t);
            this.substClassTypeCache.put(t, substct);
        }
        return substct;
    }

    protected ClassType substClassTypeImpl(ClassType t) {
        return new SubstClassType_c<Formal, Actual>(this.ts, t.position(), t, this);
    }

    @Override
    public Type substType(Type t) {
        if (t == null || t == this) {
            return t;
        }
        Type cached = this.cacheGet(t);
        if (cached == null) {
            cached = this.uncachedSubstType(t);
            this.cachePut(t, cached);
            if (Report.should_report("subst", 2)) {
                Report.report(2, "substType(" + t + ": " + t.getClass().getName() + ") = " + cached + ": " + cached.getClass().getName());
            }
        }
        return cached;
    }

    protected CacheTypeWrapper typeWrapper(Type t) {
        return new CacheTypeWrapper(t);
    }

    protected void cachePut(Type t, Type cached) {
        this.cache.put(this.typeWrapper(t), cached);
    }

    protected Type cacheGet(Type t) {
        return this.cache.get(this.typeWrapper(t));
    }

    protected boolean cacheTypeEquality(Type t1, Type t2) {
        return this.ts.equals(t1, t2);
    }

    @Override
    public PClass<Formal, Actual> substPClass(PClass<Formal, Actual> pclazz) {
        MuPClass<Formal, Actual> newPclazz = this.ts.mutablePClass(pclazz.position());
        newPclazz.formals(pclazz.formals());
        newPclazz.clazz((ClassType)this.substType(pclazz.clazz()));
        return newPclazz;
    }

    @Override
    public <T extends FieldInstance> T substField(T fi) {
        ReferenceType ct = this.substContainer(fi);
        Type t = this.substType(fi.type());
        FieldInstance newFI = (FieldInstance)fi.copy();
        newFI.setType(t);
        newFI.setContainer(ct);
        return (T)newFI;
    }

    @Override
    public <T extends MethodInstance> T substMethod(T mi) {
        ReferenceType ct = this.substContainer(mi);
        Type rt = this.substType(mi.returnType());
        List<Type> formalTypes = mi.formalTypes();
        formalTypes = this.substTypeList(formalTypes);
        List<Type> throwTypes = mi.throwTypes();
        throwTypes = this.substTypeList(throwTypes);
        MethodInstance tmpMi = (MethodInstance)mi.copy();
        tmpMi.setReturnType(rt);
        tmpMi.setFormalTypes(formalTypes);
        tmpMi.setThrowTypes(throwTypes);
        tmpMi.setContainer(ct);
        return (T)tmpMi;
    }

    @Override
    public <T extends ConstructorInstance> T substConstructor(T ci) {
        ClassType ct = (ClassType)this.substType(ci.container());
        List<Type> formalTypes = ci.formalTypes();
        formalTypes = this.substTypeList(formalTypes);
        List<Type> throwTypes = ci.throwTypes();
        throwTypes = this.substTypeList(throwTypes);
        ConstructorInstance tmpCi = (ConstructorInstance)ci.copy();
        tmpCi.setFormalTypes(formalTypes);
        tmpCi.setThrowTypes(throwTypes);
        tmpCi.setContainer(ct);
        return (T)tmpCi;
    }

    protected ReferenceType substContainer(MemberInstance mi) {
        return this.substType(mi.container()).toReference();
    }

    @Override
    public <T extends Type> List<T> substTypeList(List<? extends Type> list) {
        return new CachingTransformingList((Collection<? extends Type>)list, new TypeXform());
    }

    @Override
    public <T extends MethodInstance> List<T> substMethodList(List<T> list) {
        return new CachingTransformingList(list, new MethodXform());
    }

    @Override
    public <T extends ConstructorInstance> List<T> substConstructorList(List<T> list) {
        return new CachingTransformingList(list, new ConstructorXform());
    }

    @Override
    public <T extends FieldInstance> List<T> substFieldList(List<T> list) {
        return new CachingTransformingList(list, new FieldXform());
    }

    public boolean equals(Object o) {
        if (o instanceof Subst) {
            return this.subst.equals(((Subst)o).substitutions());
        }
        return false;
    }

    public int hashCode() {
        return this.subst.hashCode();
    }

    public String toString() {
        String str = "[";
        Iterator<Map.Entry<Formal, Actual>> iter = this.subst.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Formal, Actual> entry = iter.next();
            str = str + "<" + entry.getKey() + ": " + entry.getValue() + ">";
            if (!iter.hasNext()) continue;
            str = str + ", ";
        }
        return str + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (in instanceof TypeInputStream) {
            ParamTypeSystem ts;
            this.ts = ts = (ParamTypeSystem)((TypeInputStream)in).getTypeSystem();
        }
        this.cache = new HashMap<CacheTypeWrapper, Type>();
        this.substClassTypeCache = new HashMap<ClassType, ClassType>();
        in.defaultReadObject();
    }

    public class ConstructorXform<T extends ConstructorInstance>
    implements Transformation<T, T> {
        @Override
        public T transform(T o) {
            return Subst_c.this.substConstructor(o);
        }
    }

    public class MethodXform<T extends MethodInstance>
    implements Transformation<T, T> {
        @Override
        public T transform(T o) {
            return Subst_c.this.substMethod(o);
        }
    }

    public class FieldXform<T extends FieldInstance>
    implements Transformation<T, T> {
        @Override
        public T transform(T o) {
            return Subst_c.this.substField(o);
        }
    }

    public class TypeXform<T extends Type>
    implements Transformation<Type, T> {
        @Override
        public T transform(Type o) {
            Type result = Subst_c.this.substType(o);
            return (T)result;
        }
    }

    protected class CacheTypeWrapper {
        private final Type t;

        public CacheTypeWrapper(Type t) {
            this.t = t;
        }

        public boolean equals(Object o) {
            if (o instanceof CacheTypeWrapper) {
                CacheTypeWrapper wrapper = (CacheTypeWrapper)o;
                return Subst_c.this.cacheTypeEquality(this.t, wrapper.t);
            }
            if (o instanceof Type) {
                return Subst_c.this.cacheTypeEquality(this.t, (Type)o);
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.t);
        }

        public int hashCode() {
            return this.t == null ? 0 : this.t.hashCode();
        }
    }
}

