/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl7.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.Lang;
import polyglot.ast.LocalDecl;
import polyglot.ast.New;
import polyglot.ast.NewOps;
import polyglot.ast.Node;
import polyglot.ast.Return;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.ast.JL5NewExt;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.RawClass;
import polyglot.ext.jl7.ast.AmbDiamondTypeNode;
import polyglot.ext.jl7.ast.JL7ProcedureCallExt;
import polyglot.ext.jl7.types.DiamondType;
import polyglot.ext.jl7.types.JL7TypeSystem;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FunctionInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class JL7NewExt
extends JL7ProcedureCallExt
implements NewOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private transient Type expectedObjectType = null;

    @Override
    public New node() {
        return (New)super.node();
    }

    @Override
    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        Type type;
        CodeInstance ci;
        if (parent instanceof Return && (ci = tc.context().currentCode()) instanceof FunctionInstance) {
            this.setExpectedObjectType(((FunctionInstance)ci).returnType());
        }
        if (parent instanceof Assign) {
            Assign a = (Assign)parent;
            if (this.node() == a.right()) {
                type = a.left().type();
                if (type == null || !type.isCanonical()) {
                    return this.node();
                }
                this.setExpectedObjectType(type);
            }
        }
        if (parent instanceof LocalDecl) {
            LocalDecl ld = (LocalDecl)parent;
            type = ld.type().type();
            if (type == null || !type.isCanonical()) {
                return this.node();
            }
            this.setExpectedObjectType(type);
        }
        if (parent instanceof FieldDecl) {
            FieldDecl fd = (FieldDecl)parent;
            type = fd.type().type();
            if (type == null || !type.isCanonical()) {
                return this.node();
            }
            this.setExpectedObjectType(type);
        }
        return this.superLang().typeCheckOverride(this.node(), parent, tc);
    }

    protected Type expectedObjectType() {
        return this.expectedObjectType;
    }

    protected void setExpectedObjectType(Type type) {
        if (type == null || !type.isCanonical()) {
            this.expectedObjectType = null;
            return;
        }
        this.expectedObjectType = type;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        New n = this.node();
        TypeNode objectType = n.objectType();
        if (!(objectType.type() instanceof DiamondType)) {
            return this.superLang().typeCheck(this.node(), tc);
        }
        JL5NewExt ext5 = (JL5NewExt)JL5Ext.ext(n);
        List<TypeNode> typeArgs = ext5.typeArgs();
        if (!typeArgs.isEmpty()) {
            throw new SemanticException("Explicit type arguments cannot be used with '<>' in an allocation expression");
        }
        if (n.body() != null) {
            throw new SemanticException("'<>' cannot be used with anonymous classes");
        }
        JL7TypeSystem ts = (JL7TypeSystem)tc.typeSystem();
        if (!objectType.type().isClass()) {
            throw new SemanticException("Must have a class for a new expression.", n.position());
        }
        ArrayList<Type> argTypes = new ArrayList<Type>(n.arguments().size());
        for (Expr e : n.arguments()) {
            argTypes.add(e.type());
        }
        this.superLang().typeCheckFlags(this.node(), tc);
        this.superLang().typeCheckNested(this.node(), tc);
        DiamondType ct = (DiamondType)objectType.type().toClass();
        Context c = tc.context();
        ConstructorInstance ci = ts.findConstructor(ct, argTypes, Collections.emptyList(), c.currentClass(), this.expectedObjectType(), n.body() == null);
        ct.inferred((JL5SubstClassType)ci.container());
        n = n.constructorInstance(ci);
        return n.type(ct);
    }

    @Override
    public TypeNode findQualifiedTypeNode(AmbiguityRemover ar, ClassType outer, TypeNode objectType) throws SemanticException {
        if (objectType instanceof AmbDiamondTypeNode) {
            JL7TypeSystem ts = (JL7TypeSystem)ar.typeSystem();
            Context c = ar.context();
            ts.findMemberClass(outer, objectType.name(), c.currentClass());
            if (outer instanceof ParsedClassType) {
                ParsedClassType opct = (ParsedClassType)outer;
                c = c.pushClass(opct, opct);
            } else if (outer instanceof JL5SubstClassType) {
                JL5SubstClassType osct = (JL5SubstClassType)outer;
                c = c.pushClass(osct.base(), osct.base());
            } else if (outer instanceof RawClass) {
                RawClass orct = (RawClass)outer;
                c = c.pushClass(orct.base(), orct.base());
            }
            return (TypeNode)objectType.visit(ar.context(c));
        }
        return this.superLang().findQualifiedTypeNode(this.node(), ar, outer, objectType);
    }

    @Override
    public Expr findQualifier(AmbiguityRemover ar, ClassType ct) throws SemanticException {
        return this.superLang().findQualifier(this.node(), ar, ct);
    }

    @Override
    public ClassType findEnclosingClass(Context c, ClassType ct) {
        if (ct instanceof DiamondType) {
            DiamondType dt = (DiamondType)ct;
            ct = dt.base();
        }
        return this.superLang().findEnclosingClass(this.node(), c, ct);
    }

    @Override
    public void typeCheckFlags(TypeChecker tc) throws SemanticException {
        this.superLang().typeCheckFlags(this.node(), tc);
    }

    @Override
    public void typeCheckNested(TypeChecker tc) throws SemanticException {
        this.superLang().typeCheckNested(this.node(), tc);
    }

    @Override
    public void printQualifier(CodeWriter w, PrettyPrinter tr) {
        this.superLang().printQualifier(this.node(), w, tr);
    }

    @Override
    public void printShortObjectType(CodeWriter w, PrettyPrinter tr) {
        New n = this.node();
        this.superLang().printShortObjectType(n, w, tr);
        ClassType ct = n.objectType().type().toClass();
        if (ct instanceof DiamondType) {
            w.write("<>");
        }
    }

    @Override
    public void printBody(CodeWriter w, PrettyPrinter tr) {
        this.superLang().printBody(this.node(), w, tr);
    }

    @Override
    public boolean constantValueSet(Lang lang) {
        return this.superLang().constantValueSet(this.node(), lang);
    }

    @Override
    public boolean isConstant(Lang lang) {
        return this.superLang().isConstant(this.node(), lang);
    }

    @Override
    public Object constantValue(Lang lang) {
        return this.superLang().constantValue(this.node(), lang);
    }
}

