/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.visit;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.AnnotatedElement;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.types.AnnotationElementValue;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.frontend.Job;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class ResolveAnnotationsVisitor
extends ContextVisitor {
    public ResolveAnnotationsVisitor(Job job) {
        super(job, job.extensionInfo().typeSystem(), job.extensionInfo().nodeFactory());
    }

    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        JL5Ext ext = JL5Ext.ext(n);
        if (ext instanceof AnnotatedElement) {
            AnnotatedElement aext = (AnnotatedElement)((Object)ext);
            ArrayList<AnnotationElem> newElems = new ArrayList<AnnotationElem>(aext.annotationElems().size());
            for (AnnotationElem elem : aext.annotationElems()) {
                TypeChecker tc = new TypeChecker(this.job(), this.typeSystem(), this.nodeFactory());
                AnnotationElem ae = elem = (AnnotationElem)elem.visit(tc = (TypeChecker)tc.context(this.context()));
                if (!ae.typeName().type().isCanonical()) {
                    throw new InternalCompilerError("Couldn't type check " + elem + " during annotation resolution", elem.position());
                }
                newElems.add(elem);
            }
            n = aext.annotationElems(newElems);
            aext.setAnnotations(this.createAnnotations(newElems, n.position()));
            return n;
        }
        return n;
    }

    public Annotations createAnnotations(List<AnnotationElem> annotationElems, Position pos) throws SemanticException {
        LinkedHashMap<Type, Map<String, AnnotationElementValue>> m = new LinkedHashMap<Type, Map<String, AnnotationElementValue>>();
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        for (AnnotationElem ae : annotationElems) {
            Type annotationType = ae.typeName().type();
            m.put(annotationType, ae.toAnnotationElementValues(this.lang(), ts));
        }
        return ts.createAnnotations(m, pos);
    }
}

