/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.visit;

import java.util.ArrayList;
import java.util.Iterator;
import polyglot.ast.Call;
import polyglot.ast.Field;
import polyglot.ast.Import;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.SourceFile;
import polyglot.ext.jl5.ast.JL5Import;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class RemoveStaticImports
extends ContextVisitor {
    public RemoveStaticImports(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    @Override
    protected Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) throws SemanticException {
        ClassType currClass;
        Call c;
        MethodInstance mi;
        Field f;
        if (n instanceof SourceFile) {
            SourceFile sf = (SourceFile)n;
            ArrayList<Import> imports = new ArrayList<Import>(sf.imports());
            boolean changed = false;
            Iterator iter = imports.iterator();
            while (iter.hasNext()) {
                Import imp = (Import)iter.next();
                if (imp.kind() != JL5Import.SINGLE_STATIC_MEMBER && imp.kind() != JL5Import.STATIC_ON_DEMAND) continue;
                iter.remove();
                changed = true;
            }
            if (changed) {
                n = sf.imports(imports);
            }
        }
        if (n instanceof Field && (f = (Field)n).flags().isStatic() && f.isTargetImplicit()) {
            FieldInstance fi = f.fieldInstance();
            ClassType currClass2 = this.context().currentClass();
            if (currClass2 == null || !currClass2.isSubtype(fi.container())) {
                n = f.targetImplicit(false);
            }
        }
        if (n instanceof Call && (mi = (c = (Call)n).methodInstance()).flags().isStatic() && c.isTargetImplicit() && ((currClass = this.context().currentClass()) == null || !currClass.isSubtype(mi.container()))) {
            n = c.targetImplicit(false);
        }
        return n;
    }
}

