/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.visit;

import polyglot.ast.ClassDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.JL5Options;
import polyglot.ext.jl5.types.JL5ClassType;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.inference.LubType;
import polyglot.ext.jl5.visit.RemoveEnums;
import polyglot.frontend.Job;
import polyglot.frontend.TargetFactory;
import polyglot.types.ArrayType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.visit.Translator;

public class JL5Translator
extends Translator {
    private final boolean translateEnums;
    private final boolean removeJava5isms;

    public JL5Translator(Job job, TypeSystem ts, NodeFactory nf, TargetFactory tf) {
        super(job, ts, nf, tf);
        this.translateEnums = ((JL5Options)job.extensionInfo().getOptions()).translateEnums;
        this.removeJava5isms = ((JL5Options)job.extensionInfo().getOptions()).removeJava5isms;
    }

    public boolean removeJava5isms() {
        return this.removeJava5isms;
    }

    public boolean translateEnums() {
        return this.translateEnums;
    }

    public void translateNode(Node n, CodeWriter w) {
        ClassDecl cd;
        if (n instanceof ClassDecl && this.removeJava5isms && this.translateEnums && (cd = (ClassDecl)n).superClass() != null && cd.superClass().type().isClass() && cd.superClass().type().toClass().fullName().equals("java.lang.Enum")) {
            RemoveEnums.prettyPrintClassDeclAsEnum(cd, w, this);
            return;
        }
        if (n instanceof TypeNode) {
            TypeNode tn = (TypeNode)n;
            if (this.removeJava5isms) {
                Type t = tn.type();
                Type erastype = ((JL5TypeSystem)this.ts).erasureType(t);
                if (erastype instanceof LubType) {
                    erastype = ((LubType)erastype).calculateLub();
                    erastype = ((JL5TypeSystem)this.ts).erasureType(erastype);
                }
                w.write(this.translateType(erastype));
                return;
            }
            if (!tn.isDisambiguated()) {
                this.lang().prettyPrint((Node)tn, w, this);
                return;
            }
            w.write(tn.type().translate(this.context()));
            return;
        }
        this.lang().prettyPrint(n, w, this);
    }

    private String translateType(Type t) {
        if (t instanceof JL5SubstClassType) {
            JL5SubstClassType jct = (JL5SubstClassType)t;
            return jct.base().translate(this.context);
        }
        if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            return this.translateType(at.base()) + "[]";
        }
        return t.translate(this.context());
    }

    public void printReceiver(Receiver target, CodeWriter w) {
        Type t;
        if (target == null) {
            return;
        }
        if (target instanceof TypeNode && (t = ((TypeNode)target).type()) instanceof JL5ClassType) {
            JL5ClassType ct = (JL5ClassType)t;
            w.write(ct.translateAsReceiver(this.context()));
            return;
        }
        this.translateNode(target, w);
    }
}

