/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import polyglot.ext.jl5.types.AnnotationTypeElemInstance;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.CaptureConvertedWildCardType;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.JL5ClassType;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5Subst;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.RawClass;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.WildCardType;
import polyglot.ext.param.types.PClass;
import polyglot.ext.param.types.SubstClassType_c;
import polyglot.main.Options;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Named;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class JL5SubstClassType_c
extends SubstClassType_c<TypeVariable, ReferenceType>
implements JL5SubstClassType {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JL5SubstClassType_c(JL5TypeSystem ts, Position pos, JL5ParsedClassType base, JL5Subst subst) {
        super(ts, pos, base, subst);
        this.setDeclaration(base);
    }

    @Override
    public PClass<TypeVariable, ReferenceType> instantiatedFrom() {
        return this.base().pclass();
    }

    @Override
    public List<ReferenceType> actuals() {
        PClass<TypeVariable, ReferenceType> pc = this.instantiatedFrom();
        JL5Subst subst = (JL5Subst)this.subst;
        return subst.substTypeList(pc.formals());
    }

    @Override
    public EnumInstance enumConstantNamed(String name) {
        for (EnumInstance ei : this.enumConstants()) {
            if (!ei.name().equals(name)) continue;
            return ei;
        }
        return null;
    }

    @Override
    public List<EnumInstance> enumConstants() {
        return this.subst.substFieldList(((JL5ClassType)this.base).enumConstants());
    }

    @Override
    public AnnotationTypeElemInstance annotationElemNamed(String name) {
        for (AnnotationTypeElemInstance ai : this.annotationElems()) {
            if (!ai.name().equals(name)) continue;
            return ai;
        }
        return null;
    }

    @Override
    public List<AnnotationTypeElemInstance> annotationElems() {
        return ((JL5ClassType)this.base).annotationElems();
    }

    @Override
    public void print(CodeWriter w) {
        super.print(w);
        this.printParams(w);
    }

    @Override
    public void printParams(CodeWriter w) {
        JL5ParsedClassType ct = this.base();
        if (ct.typeVariables().isEmpty()) {
            return;
        }
        w.write("<");
        Iterator<TypeVariable> it = ct.typeVariables().iterator();
        while (it.hasNext()) {
            TypeVariable act = it.next();
            this.subst().substType(act).print(w);
            if (!it.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.write(">");
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isTopLevel()) {
            if (this.package_() != null) {
                sb.append(this.package_() + ".");
            }
            sb.append(this.name());
        } else if (this.isMember()) {
            sb.append(this.container().toString() + "." + this.name());
        } else if (this.isLocal()) {
            sb.append(this.name());
        } else if (this.isAnonymous()) {
            sb.append("<anonymous class>");
        } else {
            sb.append("<unknown class>");
        }
        JL5ParsedClassType ct = this.base();
        if (!ct.typeVariables().isEmpty()) {
            sb.append('<');
            Iterator<TypeVariable> iter = ct.typeVariables().iterator();
            while (iter.hasNext()) {
                TypeVariable act = iter.next();
                sb.append(this.subst().substType(act));
                if (!iter.hasNext()) continue;
                sb.append(',');
            }
            sb.append('>');
        }
        return sb.toString();
    }

    @Override
    public boolean isRawClass() {
        return false;
    }

    @Override
    public boolean isCastValidImpl(Type toType) {
        if (super.isCastValidImpl(toType)) {
            return true;
        }
        return this.isSubtype(toType) || toType.isSubtype(this);
    }

    @Override
    public boolean isImplicitCastValidImpl(Type toType) {
        throw new InternalCompilerError("Should not be called in JL5");
    }

    @Override
    public LinkedList<Type> isImplicitCastValidChainImpl(Type toType) {
        LinkedList<Type> chain = null;
        if (this.ts.isSubtype(this, toType)) {
            chain = new LinkedList<Type>();
            chain.add(this);
            chain.add(toType);
        }
        return chain;
    }

    @Override
    public boolean descendsFromImpl(Type ancestor) {
        if (super.descendsFromImpl(ancestor)) {
            return true;
        }
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        if (this.hasWildCardArg()) {
            try {
                Type captured = ts.applyCaptureConversion(this, null);
                if (ts.descendsFrom(captured, ancestor)) {
                    return true;
                }
            }
            catch (SemanticException e) {
                // empty catch block
            }
        }
        if (ancestor instanceof RawClass) {
            RawClass rc = (RawClass)ancestor;
            if (this.base().equals(rc.base())) {
                return true;
            }
        }
        if (ancestor instanceof JL5SubstClassType_c) {
            JL5SubstClassType_c anc = (JL5SubstClassType_c)ancestor;
            if (this.base.equals(anc.base)) {
                boolean allContained = true;
                for (TypeVariable tv : this.base().typeVariables()) {
                    Type si;
                    Type ti = this.subst.substType(tv);
                    if (ts.isContained(ti, si = anc.subst.substType(tv))) continue;
                    allContained = false;
                    break;
                }
                if (allContained) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasWildCardArg() {
        JL5ParsedClassType b = (JL5ParsedClassType)this.base;
        for (TypeVariable t : b.typeVariables()) {
            Type substType = this.subst.substType(t);
            if (!(substType instanceof WildCardType) || substType instanceof CaptureConvertedWildCardType) continue;
            return true;
        }
        return false;
    }

    @Override
    public JL5ParsedClassType base() {
        return (JL5ParsedClassType)this.base;
    }

    @Override
    public String translate(Resolver c) {
        return this.translate(this.base(), c);
    }

    private String translate(JL5ParsedClassType ct, Resolver c) {
        boolean done;
        StringBuffer sb = new StringBuffer();
        if (ct.isTopLevel()) {
            done = false;
            if (ct.package_() == null) {
                sb.append(ct.name());
                done = true;
            } else if (c != null && !Options.global.fully_qualified_names) {
                try {
                    Named x = c.find(ct.name());
                    if (this.ts.equals(ct, x)) {
                        sb.append(ct.name());
                        done = true;
                    }
                }
                catch (SemanticException e) {
                    // empty catch block
                }
            }
            if (!done) {
                sb.append(ct.package_().translate(c) + "." + ct.name());
            }
        } else if (ct.isMember()) {
            done = false;
            if (ct.container().toClass().isAnonymous()) {
                sb.append(ct.name());
                done = true;
            } else if (c != null && !Options.global.fully_qualified_names) {
                ClassType outer;
                Context ctx;
                ClassType currentClass;
                JL5TypeSystem ts;
                boolean toTry = true;
                if (ct.isInnerClass() && c instanceof Context && !(ts = (JL5TypeSystem)this.typeSystem()).isSubtype(currentClass = (ctx = (Context)c).currentClass(), outer = this.subst().substType(ct.outer()).toClass())) {
                    toTry = false;
                }
                if (toTry) {
                    try {
                        Named x = c.find(ct.name());
                        if (this.ts.equals(ct, x)) {
                            sb.append(ct.name());
                            done = true;
                        }
                    }
                    catch (SemanticException e) {
                        // empty catch block
                    }
                }
            }
            if (!done) {
                if (ct.isInnerClass()) {
                    sb.append(this.translate((JL5ParsedClassType)ct.outer(), c) + "." + ct.name());
                } else {
                    sb.append(ct.outer().translate(c) + "." + ct.name());
                }
            }
        } else if (this.isLocal()) {
            sb.append(ct.name());
        } else {
            throw new InternalCompilerError("Cannot translate an anonymous class: " + ct, ct.position());
        }
        if (ct.typeVariables().isEmpty()) {
            return sb.toString();
        }
        sb.append('<');
        Iterator<TypeVariable> iter = ct.typeVariables().iterator();
        while (iter.hasNext()) {
            TypeVariable act = iter.next();
            sb.append(this.subst().substType(act).translate(c));
            if (!iter.hasNext()) continue;
            sb.append(',');
        }
        sb.append('>');
        return sb.toString();
    }

    @Override
    public String translateAsReceiver(Resolver c) {
        if (this.isTopLevel()) {
            if (this.package_() == null) {
                return this.name();
            }
            if (c != null && !Options.global.fully_qualified_names) {
                try {
                    Named x = c.find(this.name());
                    if (this.ts.equals(this, x)) {
                        return this.name();
                    }
                }
                catch (SemanticException e) {
                    // empty catch block
                }
            }
            return this.package_().translate(c) + "." + this.name();
        }
        if (this.isMember()) {
            if (this.container().toClass().isAnonymous()) {
                return this.name();
            }
            ReferenceType container = this.container();
            if (!this.isInnerClass()) {
                JL5TypeSystem ts = (JL5TypeSystem)this.ts;
                container = (ReferenceType)ts.erasureType(this.container());
            }
            return container.translate(c) + "." + this.name();
        }
        if (this.isLocal()) {
            return this.name();
        }
        throw new InternalCompilerError("Cannot translate an anonymous class: " + this, this.position());
    }

    @Override
    public ClassType outer() {
        if (this.isMember() && !this.isInnerClass() && !(super.outer() instanceof RawClass)) {
            JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
            return (ClassType)ts.erasureType(super.outer());
        }
        return super.outer();
    }

    @Override
    public boolean isEnclosedImpl(ClassType maybe_outer) {
        if (super.isEnclosedImpl(maybe_outer)) {
            return true;
        }
        if (this.outer() != null && super.outer() != this.outer()) {
            return super.outer().equals(maybe_outer) || super.outer().isEnclosed(maybe_outer);
        }
        return false;
    }

    @Override
    public Annotations annotations() {
        return ((JL5TypeSystem)this.typeSystem()).NoAnnotations();
    }

    public Set<Type> superclasses() {
        if (this.superType() == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.superType());
    }
}

