/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.HashMap;
import polyglot.ast.ClassDecl;
import polyglot.ast.Import;
import polyglot.ast.Node;
import polyglot.ast.SourceFile;
import polyglot.ast.TopLevelDecl;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.ast.JL5Import;
import polyglot.types.Named;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.SerialVersionUID;
import polyglot.visit.TypeChecker;

public class JL5SourceFileExt
extends JL5Ext {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        SourceFile n = (SourceFile)this.superLang().typeCheck(this.node(), tc);
        HashMap<String, ParsedClassType> declaredTypes = new HashMap<String, ParsedClassType>();
        for (TopLevelDecl d : n.decls()) {
            String s = d.name();
            declaredTypes.put(s, ((ClassDecl)d).type());
        }
        TypeSystem ts = tc.typeSystem();
        HashMap<String, Named> importedTypes = new HashMap<String, Named>();
        HashMap<String, Named> staticImportedTypes = new HashMap<String, Named>();
        for (Import i : n.imports()) {
            String name;
            Named named;
            String s;
            Import.Kind kind = i.kind();
            if (kind == Import.SINGLE_TYPE) {
                s = i.name();
                named = ts.forName(s);
                name = named.name();
                importedTypes.put(name, named);
            }
            if (kind != JL5Import.SINGLE_STATIC_MEMBER) continue;
            s = i.name();
            try {
                named = ts.forName(s);
            }
            catch (SemanticException e) {
                continue;
            }
            name = named.name();
            if (importedTypes.containsKey(name)) {
                Named importedType = (Named)importedTypes.get(name);
                throw new SemanticException(name + " is already defined in a single-type import as type " + importedType + ".", i.position());
            }
            staticImportedTypes.put(name, named);
            if (!declaredTypes.containsKey(name)) continue;
            Named declaredType = (Named)declaredTypes.get(name);
            throw new SemanticException("The static import " + s + " conflicts with type " + declaredType + " defined in the same file.", i.position());
        }
        return n;
    }
}

