/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.ProcedureDeclOps;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.JL5AnnotatedElementExt;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.ast.JL5FormalExt;
import polyglot.ext.jl5.ast.ParamTypeNode;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.JL5ArrayType;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5LocalInstance;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.visit.JL5Translator;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.ListUtil;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public abstract class JL5ProcedureDeclExt
extends JL5AnnotatedElementExt
implements ProcedureDeclOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<ParamTypeNode> typeParams;

    public JL5ProcedureDeclExt(List<ParamTypeNode> typeParams, List<AnnotationElem> annotations) {
        super(annotations);
        this.typeParams = ListUtil.copy(typeParams, true);
    }

    public List<ParamTypeNode> typeParams() {
        return this.typeParams;
    }

    public Node typeParams(List<ParamTypeNode> typeParams) {
        return this.typeParams(this.node(), typeParams);
    }

    protected <N extends Node> N typeParams(N n, List<ParamTypeNode> typeParams) {
        JL5ProcedureDeclExt ext = (JL5ProcedureDeclExt)JL5Ext.ext(n);
        if (CollectionUtil.equals(ext.typeParams, typeParams)) {
            return n;
        }
        if (n == this.node) {
            n = Copy.Util.copy(n);
            ext = (JL5ProcedureDeclExt)JL5Ext.ext(n);
        }
        ext.typeParams = ListUtil.copy(typeParams, true);
        return n;
    }

    @Override
    public void setAnnotations(Annotations annotations) {
        ProcedureDecl pd = (ProcedureDecl)this.node();
        JL5ProcedureInstance pi = (JL5ProcedureInstance)pd.procedureInstance();
        pi.setAnnotations(annotations);
    }

    protected Node reconstruct(Node n, List<ParamTypeNode> typeParams) {
        n = this.typeParams(n, typeParams);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List<ParamTypeNode> typeParams = this.visitList(this.typeParams, v);
        Node n = super.visitChildren(v);
        return this.reconstruct(n, typeParams);
    }

    @Override
    public Context enterScope(Context c) {
        ProcedureDecl pd = (ProcedureDecl)this.node();
        c = this.superLang().enterScope(pd, c);
        for (TypeNode typeNode : this.typeParams) {
            ((JL5Context)c).addTypeVariable((TypeVariable)typeNode.type());
        }
        return c;
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        ProcedureDecl pd = (ProcedureDecl)this.node();
        JL5TypeSystem ts = (JL5TypeSystem)tb.typeSystem();
        ParsedClassType ct = tb.currentClass();
        if (ct == null) {
            return pd;
        }
        boolean isVarArgs = false;
        ArrayList<UnknownType> formalTypes = new ArrayList<UnknownType>(pd.formals().size());
        for (int i = 0; i < pd.formals().size(); ++i) {
            formalTypes.add(ts.unknownType(pd.position()));
            Formal f = pd.formals().get(i);
            JL5FormalExt fext = (JL5FormalExt)JL5Ext.ext(f);
            if (!fext.isVarArg()) continue;
            isVarArgs = true;
        }
        ArrayList<UnknownType> throwTypes = new ArrayList<UnknownType>(pd.throwTypes().size());
        for (int i = 0; i < pd.throwTypes().size(); ++i) {
            throwTypes.add(ts.unknownType(pd.position()));
        }
        ArrayList<TypeVariable> typeParams = new ArrayList<TypeVariable>(this.typeParams.size());
        for (int i = 0; i < this.typeParams.size(); ++i) {
            typeParams.add(ts.unknownTypeVariable(pd.position()));
        }
        Flags flags = pd.flags();
        if (isVarArgs) {
            flags = JL5Flags.setVarArgs(flags);
        }
        return this.buildTypesFinish(ts, ct, flags, formalTypes, throwTypes, typeParams);
    }

    protected abstract Node buildTypesFinish(JL5TypeSystem var1, ParsedClassType var2, Flags var3, List<? extends Type> var4, List<? extends Type> var5, List<TypeVariable> var6);

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        ProcedureDecl n = (ProcedureDecl)this.superLang().disambiguate(this.node(), ar);
        ArrayList<TypeVariable> typeParams = new ArrayList<TypeVariable>(this.typeParams.size());
        for (TypeNode typeNode : this.typeParams) {
            if (!typeNode.isDisambiguated()) {
                return n;
            }
            TypeVariable tv = (TypeVariable)typeNode.type();
            typeParams.add(tv);
        }
        JL5ProcedureInstance pi = (JL5ProcedureInstance)n.procedureInstance();
        pi.setTypeParams(typeParams);
        return n;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        ProcedureDecl pd = (ProcedureDecl)this.node();
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        JL5ProcedureInstance pi = (JL5ProcedureInstance)pd.procedureInstance();
        ts.checkDuplicateAnnotations(this.annotations);
        for (TypeNode typeNode : this.typeParams) {
            ts.checkCycles(typeNode.type().toReference());
        }
        for (Formal formal : pd.formals()) {
            JL5LocalInstance li = (JL5LocalInstance)formal.localInstance();
            li.setProcedureFormal(true);
        }
        for (int i = 0; i < pd.formals().size(); ++i) {
            Formal formal = pd.formals().get(i);
            JL5FormalExt fext = (JL5FormalExt)JL5Ext.ext(formal);
            if (!fext.isVarArg()) continue;
            if (i != pd.formals().size() - 1) {
                throw new SemanticException("Only last formal can be variable in method declaration.", formal.position());
            }
            pi.setFlags(JL5Flags.setVarArgs(pi.flags()));
            pd = pd.flags(JL5Flags.setVarArgs(pd.flags()));
        }
        Flags flags = pi.flags();
        if (JL5Flags.isVarArgs(pd.flags()) != JL5Flags.isVarArgs(flags)) {
            throw new InternalCompilerError("VarArgs flag of AST and type disagree");
        }
        if (JL5Flags.isVarArgs(flags)) {
            if (pi.formalTypes().isEmpty()) {
                throw new InternalCompilerError("Inconsistent var args flag with procedure type");
            }
            Type type = pi.formalTypes().get(pi.formalTypes().size() - 1);
            if (!(type instanceof JL5ArrayType) || !((JL5ArrayType)type).isVarArg()) {
                throw new InternalCompilerError("Inconsistent var args flag with procedure type");
            }
        }
        return pd;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter pp) {
        this.superLang().prettyPrint((Node)this.node(), w, pp);
    }

    @Override
    public void prettyPrintHeader(Flags flags, CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        w.begin(0);
        super.prettyPrint(w, tr);
        w.end();
        w.write(JL5Flags.clearVarArgs(flags).translate());
        boolean printTypeVars = true;
        if (tr instanceof JL5Translator) {
            JL5Translator jl5tr = (JL5Translator)tr;
            boolean bl = printTypeVars = !jl5tr.removeJava5isms();
        }
        if (printTypeVars && !this.typeParams.isEmpty()) {
            w.write("<");
            Iterator<ParamTypeNode> iter = this.typeParams.iterator();
            while (iter.hasNext()) {
                TypeNode ptn = iter.next();
                tr.lang().prettyPrint((Node)ptn, w, tr);
                if (!iter.hasNext()) continue;
                w.write(",");
                w.allowBreak(0, " ");
            }
            w.write("> ");
        }
        ProcedureDecl n = (ProcedureDecl)this.node();
        this.prettyPrintName(w, tr);
        w.write("(");
        w.begin(0);
        Iterator<Term> i = n.formals().iterator();
        while (i.hasNext()) {
            Formal f = i.next();
            tr.print(n, f, w);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(")");
        if (!n.throwTypes().isEmpty()) {
            w.allowBreak(6);
            w.write("throws ");
            i = n.throwTypes().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                tr.print(n, tn, w);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(4, " ");
            }
        }
        w.end();
    }

    protected abstract void prettyPrintName(CodeWriter var1, PrettyPrinter var2);
}

