/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.List;
import polyglot.ast.Import;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.ast.JL5Import;
import polyglot.ext.jl5.types.JL5ImportTable;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Package;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.SerialVersionUID;
import polyglot.util.StringUtil;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class JL5ImportExt
extends JL5Ext {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Import im = (Import)this.node();
        JL5ImportTable it = (JL5ImportTable)tb.importTable();
        if (im.kind() == JL5Import.SINGLE_STATIC_MEMBER) {
            it.addSingleStaticImport(im.name(), im.position());
        } else if (im.kind() == JL5Import.STATIC_ON_DEMAND) {
            it.addStaticOnDemandImport(im.name(), im.position());
        }
        return this.superLang().buildTypes(im, tb);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Import n = (Import)this.node();
        if (n.kind() == JL5Import.SINGLE_STATIC_MEMBER) {
            Type nt = (Type)((Object)tc.typeSystem().forName(StringUtil.getPackageComponent(n.name())));
            String id = StringUtil.getShortNameComponent(n.name());
            if (!JL5ImportExt.isIdStaticMember(nt.toClass(), id, (JL5TypeSystem)tc.typeSystem(), tc.context().package_())) {
                throw new SemanticException("Cannot find static member " + id + " in class: " + nt, n.position());
            }
            return n;
        }
        return this.superLang().typeCheck(this.node(), tc);
    }

    private static boolean isIdStaticMember(ClassType t, String id, JL5TypeSystem ts, Package package_) {
        if (!ts.classAccessibleFromPackage(t.toClass(), package_)) {
            return false;
        }
        try {
            FieldInstance fi = ts.findField(t, id, t.toClass(), true);
            if (fi != null && fi.flags().isStatic() && ts.accessibleFromPackage(fi.flags(), t.package_(), package_)) {
                return true;
            }
        }
        catch (SemanticException e) {
            // empty catch block
        }
        if (ts.hasMethodNamed(t, id)) {
            List<? extends MethodInstance> meths = t.methodsNamed(id);
            boolean anyAccessible = false;
            for (MethodInstance methodInstance : meths) {
                if (!methodInstance.flags().isStatic() || !ts.accessibleFromPackage(methodInstance.flags(), t.package_(), package_)) continue;
                anyAccessible = true;
                break;
            }
            return anyAccessible;
        }
        try {
            ClassType ct = ts.findMemberClass(t, id);
            if (ct != null && ct.flags().isStatic() && ts.accessibleFromPackage(ct.flags(), t.package_(), package_)) {
                return true;
            }
        }
        catch (SemanticException e) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        Import n = (Import)this.node();
        if (n.kind() == JL5Import.SINGLE_STATIC_MEMBER || n.kind() == JL5Import.STATIC_ON_DEMAND) {
            w.write("import static ");
            w.write(n.name());
            if (n.kind() == JL5Import.STATIC_ON_DEMAND) {
                w.write(".*");
            }
            w.write(";");
            w.newline(0);
        } else {
            this.superLang().prettyPrint(this.node(), w, tr);
        }
    }
}

