/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.List;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.JL5AnnotatedElementExt;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.JL5ArrayType;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5LocalInstance;
import polyglot.types.ArrayType;
import polyglot.types.Declaration;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class JL5FormalExt
extends JL5AnnotatedElementExt {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected boolean isVarArg = false;
    protected boolean isCatchFormal = false;

    public JL5FormalExt() {
        this(false, null);
    }

    public JL5FormalExt(boolean isVarArg, List<AnnotationElem> annotations) {
        super(annotations);
        this.isVarArg = isVarArg;
    }

    public boolean isVarArg() {
        return this.isVarArg;
    }

    public boolean isCatchFormal() {
        return this.isCatchFormal;
    }

    public void setIsCatchFormal(boolean isCatchFormal) {
        this.isCatchFormal = isCatchFormal;
    }

    @Override
    public void setAnnotations(Annotations annotations) {
        Formal f = (Formal)this.node();
        JL5LocalInstance li = (JL5LocalInstance)f.localInstance();
        li.setAnnotations(annotations);
    }

    @Override
    protected Declaration declaration() {
        Formal f = (Formal)this.node();
        return f.localInstance();
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Formal f = (Formal)this.node();
        if (!f.flags().clear(Flags.FINAL).equals(Flags.NONE)) {
            throw new SemanticException("Modifier: " + f.flags().clearFinal() + " not allowed here.", f.position());
        }
        return super.typeCheck(tc);
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        Formal f = (Formal)this.node();
        if (this.isVarArg) {
            ((JL5ArrayType)f.type().type()).setVarArg();
        }
        return this.superLang().disambiguate(this.node(), ar);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        super.prettyPrint(w, tr);
        Formal f = (Formal)this.node();
        w.write(JL5Flags.clearVarArgs(f.flags()).translate());
        if (this.isVarArg) {
            w.write(((ArrayType)f.type().type()).base().toString());
            w.write(" ...");
        } else {
            this.print(f.type(), w, tr);
        }
        w.write(" ");
        w.write(f.name());
    }
}

