/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.JLang;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.EnumConstantDecl;
import polyglot.ext.jl5.ast.JL5ClassDeclExt;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5MethodInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.ConstructorInstance;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.SerialVersionUID;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class JL5EnumDeclExt
extends JL5ClassDeclExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JL5EnumDeclExt() {
        this((List<AnnotationElem>)null);
    }

    public JL5EnumDeclExt(List<AnnotationElem> annotations) {
        super(Collections.emptyList(), annotations);
    }

    public ClassDecl addValueOfMethodType(TypeSystem ts) {
        ClassDecl n = this.node();
        Flags flags = Flags.PUBLIC.set(Flags.STATIC.set(Flags.FINAL));
        JL5MethodInstance valueOfMI = (JL5MethodInstance)ts.methodInstance(n.position(), n.type(), flags, n.type(), "valueOf", Collections.singletonList(ts.String()), Collections.emptyList());
        n.type().addMethod(valueOfMI);
        return n;
    }

    public ClassDecl addValuesMethodType(TypeSystem ts) {
        ClassDecl n = this.node();
        Flags flags = Flags.PUBLIC.set(Flags.STATIC.set(Flags.FINAL));
        JL5MethodInstance valuesMI = (JL5MethodInstance)ts.methodInstance(n.position(), n.type(), flags.set(Flags.NATIVE), ts.arrayOf(n.type()), "values", Collections.emptyList(), Collections.emptyList());
        n.type().addMethod(valuesMI);
        return n;
    }

    public Node addEnumMethodTypesIfNeeded(TypeSystem ts) {
        ClassDecl n = this.node();
        JL5EnumDeclExt ext = (JL5EnumDeclExt)JL5Ext.ext(n);
        JL5ParsedClassType ct = (JL5ParsedClassType)n.type();
        if (ct.enumValueOfMethodNeeded()) {
            n = ext.addValueOfMethodType(ts);
        }
        if (ct.enumValuesMethodNeeded()) {
            n = ext.addValuesMethodType(ts);
        }
        return n;
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        ClassDecl n = (ClassDecl)super.buildTypes(tb);
        JL5EnumDeclExt ext = (JL5EnumDeclExt)JL5Ext.ext(n);
        if (n.type().isMember()) {
            n = n.flags(n.flags().Static());
            n.type().flags(n.type().flags().Static());
        }
        try {
            JL5TypeSystem ts = (JL5TypeSystem)tb.typeSystem();
            return ext.addEnumMethodTypesIfNeeded(ts);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        ClassDecl n = this.node();
        for (MethodInstance methodInstance : n.type().methods()) {
            if (!methodInstance.flags().isAbstract()) continue;
            n.type().setFlags(n.type().flags().Abstract());
        }
        return this.superLang().typeCheckEnter(this.node(), tc);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        ClassDecl n = this.node();
        if (n.flags().isAbstract()) {
            throw new SemanticException("Enum types cannot have abstract modifier", n.position());
        }
        if (n.flags().isPrivate() && !n.type().isNested()) {
            throw new SemanticException("Top level enum types cannot have private modifier", n.position());
        }
        if (n.flags().isFinal()) {
            throw new SemanticException("Enum types cannot have final modifier", n.position());
        }
        for (ConstructorInstance constructorInstance : n.type().constructors()) {
            if (JL5Flags.clearVarArgs(constructorInstance.flags().clear(Flags.PRIVATE)).equals(Flags.NONE)) continue;
            throw new SemanticException("Modifier " + constructorInstance.flags().clear(Flags.PRIVATE) + " not allowed here", constructorInstance.position());
        }
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        if (ts.rawClass((JL5ParsedClassType)ts.Enum()).equals(n.type().superType())) {
            n.type().superType(ts.instantiate(n.position(), (JL5ParsedClassType)ts.Enum(), Collections.singletonList(n.type())));
        }
        if ((n = (ClassDecl)super.typeCheck(tc)).type().isMember()) {
            n = n.flags(n.flags().Static());
            n.type().flags(n.type().flags().Static());
        }
        for (ClassMember m : n.body().members()) {
            if (!m.memberInstance().flags().isAbstract() || !(m instanceof MethodDecl)) continue;
            n.type().flags(n.type().flags().Abstract());
            break;
        }
        return n;
    }

    @Override
    public Node addDefaultConstructor(TypeSystem ts, NodeFactory nf, ConstructorInstance defaultCI) throws SemanticException {
        ClassDecl n = this.node();
        ConstructorInstance ci = defaultCI;
        if (ci == null) {
            throw new InternalCompilerError("addDefaultConstructor called without defaultCI set");
        }
        ConstructorDecl cd = nf.ConstructorDecl(n.body().position().startOf(), Flags.PRIVATE, n.id(), Collections.emptyList(), Collections.emptyList(), nf.Block(n.position().startOf(), new Stmt[0]));
        cd = cd.constructorInstance(ci);
        return n.body(n.body().addMember(cd));
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        ClassDecl n = this.node();
        ((JLang)tr.lang()).prettyPrintHeader(n, w, tr);
        boolean hasEnumConstant = false;
        for (ClassMember m : n.body().members()) {
            if (!(m instanceof EnumConstantDecl)) continue;
            hasEnumConstant = true;
            break;
        }
        if (!hasEnumConstant) {
            w.write(";");
        }
        this.print(n.body(), w, tr);
        ((JLang)tr.lang()).prettyPrintFooter(n, w, tr);
    }
}

