/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import polyglot.ast.Conditional;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.JL5ExprExt;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.inference.LubType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;
import polyglot.util.SerialVersionUID;
import polyglot.visit.TypeChecker;

public class JL5ConditionalExt
extends JL5ExprExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        Conditional c = (Conditional)this.node();
        Expr e1 = c.consequent();
        Expr e2 = c.alternative();
        Expr cond = c.cond();
        Type t1 = e1.type();
        Type t2 = e2.type();
        if (!ts.isImplicitCastValid(cond.type(), ts.Boolean())) {
            throw new SemanticException("Condition of ternary expression must be of type boolean.", cond.position());
        }
        if (ts.typeEquals(t1, t2)) {
            return c.type(t1);
        }
        if (ts.typeEquals(t1, ts.Boolean()) && ts.typeEquals(t2, ts.typeForName("java.lang.Boolean")) || ts.typeEquals(t2, ts.Boolean()) && ts.typeEquals(t1, ts.typeForName("java.lang.Boolean"))) {
            return c.type(ts.Boolean());
        }
        if (t1.isNull()) {
            if (t2.isReference()) {
                return c.type(t2);
            }
            if (t2.isPrimitive()) {
                return c.type(ts.boxingConversion(t2));
            }
        }
        if (t2.isNull()) {
            if (t1.isReference()) {
                return c.type(t1);
            }
            if (t1.isPrimitive()) {
                return c.type(ts.boxingConversion(t1));
            }
        }
        if (ts.unboxingConversion(t1).isNumeric() && ts.unboxingConversion(t2).isNumeric()) {
            if ((t1.isByte() || t1.equals(ts.typeForName("java.lang.Byte"))) && (t2.isShort() || t2.equals(ts.typeForName("java.lang.Short")))) {
                return c.type(ts.Short());
            }
            if ((t2.isByte() || t2.equals(ts.typeForName("java.lang.Byte"))) && (t1.isShort() || t1.equals(ts.typeForName("java.lang.Short")))) {
                return c.type(ts.Short());
            }
            if (t1.isIntOrLess() && t2.isInt() && ts.numericConversionValid(t1, tc.lang().constantValue(e2, tc.lang()))) {
                return c.type(t1);
            }
            if (t2.isIntOrLess() && t1.isInt() && ts.numericConversionValid(t2, tc.lang().constantValue(e1, tc.lang()))) {
                return c.type(t2);
            }
            if (t1.equals(ts.typeForName("java.lang.Byte")) && t2.isInt() && ts.numericConversionValid((Type)ts.Byte(), tc.lang().constantValue(e2, tc.lang()))) {
                return c.type(ts.Byte());
            }
            if (t2.equals(ts.typeForName("java.lang.Byte")) && t1.isInt() && ts.numericConversionValid((Type)ts.Byte(), tc.lang().constantValue(e1, tc.lang()))) {
                return c.type(ts.Byte());
            }
            if (t1.equals(ts.typeForName("java.lang.Short")) && t2.isInt() && ts.numericConversionValid((Type)ts.Short(), tc.lang().constantValue(e2, tc.lang()))) {
                return c.type(ts.Short());
            }
            if (t2.equals(ts.typeForName("java.lang.Short")) && t1.isInt() && ts.numericConversionValid((Type)ts.Short(), tc.lang().constantValue(e1, tc.lang()))) {
                return c.type(ts.Short());
            }
            if (t1.equals(ts.typeForName("java.lang.Character")) && t2.isInt() && ts.numericConversionValid((Type)ts.Char(), tc.lang().constantValue(e2, tc.lang()))) {
                return c.type(ts.Char());
            }
            if (t2.equals(ts.typeForName("java.lang.Character")) && t1.isInt() && ts.numericConversionValid((Type)ts.Char(), tc.lang().constantValue(e1, tc.lang()))) {
                return c.type(ts.Char());
            }
            return c.type(ts.promote(t1, t2));
        }
        return c.type(this.find_lub(ts, t1, t2));
    }

    public Type find_lub(JL5TypeSystem ts, Type t1, Type t2) throws SemanticException {
        if (t1.isArray() && t2.isArray() && t1.toArray().base().isReference() && t2.toArray().base().isReference()) {
            Type base_lub = this.find_lub(ts, t1.toArray().base(), t2.toArray().base());
            return ts.arrayOf(base_lub);
        }
        ReferenceType s1 = (ReferenceType)ts.boxingConversion(t1);
        ReferenceType s2 = (ReferenceType)ts.boxingConversion(t2);
        LubType lub = ts.lub(this.node().position(), CollectionUtil.list(s1, s2));
        return ts.applyCaptureConversion(lub.calculateLub(), this.node().position());
    }
}

