/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import polyglot.ast.AmbExpr;
import polyglot.ast.Ambiguous;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Case;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Lit;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.EnumConstant;
import polyglot.ext.jl5.ast.JL5CaseOps;
import polyglot.ext.jl5.ast.JL5NodeFactory;
import polyglot.ext.jl5.ast.JL5TermExt;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.ConstantChecker;
import polyglot.visit.ContextVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class JL5CaseExt
extends JL5TermExt
implements JL5CaseOps {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public Case node() {
        return (Case)super.node();
    }

    @Override
    public Case resolveCaseLabel(TypeChecker tc, Type switchType) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        JL5NodeFactory nf = (JL5NodeFactory)tc.nodeFactory();
        Case c = this.node();
        Expr expr = c.expr();
        if (expr == null) {
            return c;
        }
        if (switchType.isClass() && !this.isNumericSwitchType(switchType, ts)) {
            if (expr.type().isCanonical()) {
                EnumConstant ec = (EnumConstant)expr;
                return c.value(ec.enumInstance().ordinal());
            }
            if (expr instanceof EnumConstant) {
                Field ec = (Field)expr;
                EnumConstant ext = (EnumConstant)ec;
                EnumInstance ei = ts.findEnumConstant(switchType.toReference(), ec.name());
                ec = (Field)ext.enumInstance(ei);
                ec = (Field)ec.type(ei.type());
                return c.expr(ec).value(ei.ordinal());
            }
            if (expr instanceof AmbExpr) {
                AmbExpr amb = (AmbExpr)expr;
                EnumInstance ei = ts.findEnumConstant(switchType.toReference(), amb.name());
                CanonicalTypeNode r = nf.CanonicalTypeNode(Position.compilerGenerated(), switchType);
                Field e = nf.EnumConstant(expr.position(), r, amb.id());
                e = (Field)e.enumInstance(ei);
                e = (Field)e.type(ei.type());
                return c.expr(e).value(ei.ordinal());
            }
            throw new InternalCompilerError("Unexpected case label " + expr);
        }
        Case n = c;
        if (!expr.isTypeChecked()) {
            if (expr instanceof AmbExpr) {
                AmbExpr amb = (AmbExpr)expr;
                Expr e = (Expr)tc.nodeFactory().disamb().disambiguate((Ambiguous)amb, (ContextVisitor)tc, expr.position(), null, amb.id());
                e = (Expr)e.visit(tc);
                n = n.expr(e);
            } else {
                n = c.expr((Expr)c.expr().visit(tc));
            }
        }
        if (!tc.lang().constantValueSet(n.expr(), tc.lang())) {
            return n;
        }
        if (tc.lang().isConstant(n.expr(), tc.lang())) {
            Object o = tc.lang().constantValue(n.expr(), tc.lang());
            if (o instanceof Number && !(o instanceof Long) && !(o instanceof Float) && !(o instanceof Double)) {
                return n.value(((Number)o).longValue());
            }
            if (o instanceof Character) {
                return n.value(((Character)o).charValue());
            }
        }
        throw new SemanticException("Case label must be an integral constant or an unqualified enum value.", this.node().position());
    }

    public boolean isNumericSwitchType(Type switchType, JL5TypeSystem ts) {
        if (ts.Char().equals(switchType) || ts.wrapperClassOfPrimitive(ts.Char()).equals(switchType)) {
            return true;
        }
        if (ts.Byte().equals(switchType) || ts.wrapperClassOfPrimitive(ts.Byte()).equals(switchType)) {
            return true;
        }
        if (ts.Short().equals(switchType) || ts.wrapperClassOfPrimitive(ts.Short()).equals(switchType)) {
            return true;
        }
        return ts.Int().equals(switchType) || ts.wrapperClassOfPrimitive(ts.Int()).equals(switchType);
    }

    @Override
    public Node disambiguateOverride(Node parent, AmbiguityRemover ar) throws SemanticException {
        Case c = this.node();
        Expr expr = c.expr();
        if (expr instanceof AmbExpr) {
            return c;
        }
        return null;
    }

    @Override
    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        Case c = this.node();
        Expr expr = c.expr();
        if (expr == null || expr instanceof Lit) {
            return null;
        }
        return c;
    }

    @Override
    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        Case c = this.node();
        Expr expr = c.expr();
        if (expr == null) {
            return c;
        }
        if (!cc.lang().constantValueSet(expr, cc.lang())) {
            return c;
        }
        if (expr instanceof EnumConstant) {
            return c;
        }
        return this.superLang().checkConstants(this.node(), cc);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        Case c = this.node();
        Expr expr = c.expr();
        if (expr == null) {
            w.write("default:");
        } else {
            JL5TypeSystem ts;
            w.write("case ");
            JL5TypeSystem jL5TypeSystem = ts = expr.type() == null ? null : (JL5TypeSystem)expr.type().typeSystem();
            if (ts != null && expr.type().isReference() && expr.type().isSubtype(ts.toRawType(ts.Enum()))) {
                Field f = (Field)expr;
                w.write(f.name());
            } else {
                this.print(expr, w, tr);
            }
            w.write(":");
        }
    }
}

