/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.FloatLit;
import polyglot.ast.IntLit;
import polyglot.ast.Lit;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Loop_c;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ext.jl5.ast.ExtendedFor;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.RawClass;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class ExtendedFor_c
extends Loop_c
implements ExtendedFor {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected LocalDecl decl;
    protected Expr expr;

    public ExtendedFor_c(Position pos, LocalDecl decl, Expr expr, Stmt body) {
        super(pos, null, body);
        assert (decl != null && expr != null);
        this.decl = decl;
        this.expr = expr;
    }

    @Override
    public LocalDecl decl() {
        return this.decl;
    }

    @Override
    public ExtendedFor decl(LocalDecl decl) {
        return this.decl(this, decl);
    }

    protected <N extends ExtendedFor_c> N decl(N n, LocalDecl decl) {
        N ext = n;
        if (ext.decl.equals(decl)) {
            return n;
        }
        if (n == this) {
            ext = n = Copy.Util.copy(n);
        }
        ext.decl = decl;
        return n;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public ExtendedFor expr(Expr expr) {
        return this.expr(this, expr);
    }

    protected <N extends ExtendedFor_c> N expr(N n, Expr expr) {
        N ext = n;
        if (ext.expr == expr) {
            return n;
        }
        if (n == this) {
            ext = n = Copy.Util.copy(n);
        }
        ext.expr = expr;
        return n;
    }

    protected <N extends ExtendedFor_c> N reconstruct(N n, LocalDecl decl, Expr expr) {
        n = this.decl(n, decl);
        n = this.expr(n, expr);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        ExtendedFor_c n = this;
        LocalDecl decl = this.visitChild(this.decl, v);
        Expr expr = this.visitChild(this.expr, v);
        Stmt body = this.visitChild(n.body(), v);
        return this.reconstruct(n, decl, expr).body(body);
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushBlock();
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Lit lit;
        Type elementType;
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        NodeFactory nf = tc.nodeFactory();
        ExtendedFor_c n = this;
        Position position = n.position();
        Type t = this.expr.type();
        if (!this.expr.type().isArray() && !t.isSubtype(ts.rawClass((JL5ParsedClassType)ts.Iterable()))) {
            throw new SemanticException("Can only iterate over an array or an instance of java.util.Iterable", this.expr.position());
        }
        Type declType = this.decl().localInstance().type();
        if (this.expr.type().isArray()) {
            elementType = this.expr.type().toArray().base();
        } else if (t instanceof RawClass) {
            elementType = ts.Object();
        } else {
            JL5SubstClassType iterableType = ts.findGenericSupertype((JL5ParsedClassType)ts.Iterable(), t.toReference());
            if (iterableType == null) {
                throw new InternalCompilerError("Cannot find generic supertype of Iterable for " + t.toReference(), position);
            }
            elementType = (Type)iterableType.actuals().get(0);
        }
        if (!elementType.isImplicitCastValid(declType)) {
            throw new SemanticException("Incompatible types: required " + declType + " but found " + elementType, position);
        }
        if (this.expr instanceof Local && this.decl.localInstance().equals(((Local)this.expr).localInstance())) {
            throw new SemanticException("Variable: " + this.expr + " may not have been initialized", this.expr.position());
        }
        if (this.expr instanceof NewArray && ((NewArray)this.expr).init() != null) {
            for (Expr next : ((NewArray)this.expr).init().elements()) {
                if (!(next instanceof Local) || !this.decl.localInstance().equals(((Local)next).localInstance())) continue;
                throw new SemanticException("Varaible: " + next + " may not have been initialized", next.position());
            }
        }
        Type type = this.decl.declType();
        Position pos = Position.compilerGenerated();
        if (type.isReference()) {
            lit = (Lit)nf.NullLit(pos).type(type.typeSystem().Null());
        } else if (type.isBoolean()) {
            lit = (Lit)nf.BooleanLit(pos, false).type(type);
        } else if (type.isInt() || type.isShort() || type.isChar() || type.isByte()) {
            lit = (Lit)nf.IntLit(pos, IntLit.INT, 0L).type(type);
        } else if (type.isLong()) {
            lit = (Lit)nf.IntLit(pos, IntLit.LONG, 0L).type(type);
        } else if (type.isFloat()) {
            lit = (Lit)nf.FloatLit(pos, FloatLit.FLOAT, 0.0).type(type);
        } else if (type.isDouble()) {
            lit = (Lit)nf.FloatLit(pos, FloatLit.DOUBLE, 0.0).type(type);
        } else {
            throw new InternalCompilerError("Don't know default value for type " + type);
        }
        return this.decl(this.decl.init(lit));
    }

    @Override
    public Term firstChild() {
        return this.expr;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        ExtendedFor_c n = this;
        v.visitCFG(this.expr, FlowGraph.EDGE_KEY_TRUE, this.decl, 1, FlowGraph.EDGE_KEY_FALSE, n, 0);
        v.visitCFG(this.decl, n.body(), 1);
        v.push(n).visitCFG(n.body(), this.continueTarget(), 1);
        return succs;
    }

    @Override
    public Term continueTarget() {
        ExtendedFor_c n = this;
        return n.body();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("for (");
        w.begin(0);
        boolean oldSemiColon = tr.appendSemicolon(false);
        this.printBlock(this.decl.init(null), w, tr);
        tr.appendSemicolon(oldSemiColon);
        w.allowBreak(1, " ");
        w.write(":");
        w.allowBreak(1, " ");
        this.print(this.expr, w, tr);
        w.end();
        w.write(")");
        ExtendedFor_c n = this;
        this.printSubStmt(n.body(), w, tr);
    }
}

