/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CodeBlock;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.AnnotationElemDecl;
import polyglot.ext.jl5.ast.ElementValueArrayInit;
import polyglot.ext.jl5.types.AnnotationTypeElemInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.CodeInstance;
import polyglot.types.Flags;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class AnnotationElemDecl_c
extends Term_c
implements AnnotationElemDecl {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected TypeNode type;
    protected Flags flags;
    protected Term defaultVal;
    protected Id name;
    protected AnnotationTypeElemInstance ai;

    public AnnotationElemDecl_c(Position pos, Flags flags, TypeNode type, Id name, Term defaultVal) {
        super(pos);
        this.type = type;
        this.flags = flags;
        this.defaultVal = defaultVal;
        this.name = name;
    }

    @Override
    public TypeNode type() {
        return this.type;
    }

    @Override
    public AnnotationElemDecl type(TypeNode type) {
        return this.type(this, type);
    }

    protected <N extends AnnotationElemDecl_c> N type(N n, TypeNode type) {
        if (n.type.equals(type)) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.type = type;
        return n;
    }

    @Override
    public Flags flags() {
        return this.flags;
    }

    @Override
    public AnnotationElemDecl flags(Flags flags) {
        return this.flags(this, flags);
    }

    protected <N extends AnnotationElemDecl_c> N flags(N n, Flags flags) {
        if (n.flags.equals(flags)) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.flags = flags;
        return n;
    }

    @Override
    public Term defaultVal() {
        return this.defaultVal;
    }

    @Override
    public AnnotationElemDecl defaultVal(Term def) {
        return this.defaultVal(this, def);
    }

    protected <N extends AnnotationElemDecl_c> N defaultVal(N n, Term defaultVal) {
        if (n.defaultVal == defaultVal) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.defaultVal = defaultVal;
        return n;
    }

    @Override
    public Id id() {
        return this.name;
    }

    @Override
    public AnnotationElemDecl id(Id name) {
        return this.id(this, name);
    }

    protected <N extends AnnotationElemDecl_c> N id(N n, Id name) {
        if (n.name.equals(name)) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.name = name;
        return n;
    }

    @Override
    public String name() {
        return this.name.id();
    }

    @Override
    public AnnotationElemDecl name(String name) {
        return this.id(this.name.id(name));
    }

    @Override
    public AnnotationTypeElemInstance annotationElemInstance() {
        return this.ai;
    }

    @Override
    public AnnotationElemDecl annotationElemInstance(AnnotationTypeElemInstance ai) {
        return this.annotationElemInstance(this, ai);
    }

    protected <N extends AnnotationElemDecl_c> N annotationElemInstance(N n, AnnotationTypeElemInstance ai) {
        if (n.ai == ai) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.ai = ai;
        return n;
    }

    protected AnnotationElemDecl_c reconstruct(TypeNode type, Term defaultVal) {
        AnnotationElemDecl_c n = this;
        n = this.type(n, type);
        n = this.defaultVal(n, defaultVal);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode type = this.visitChild(this.type, v);
        Term defVal = this.visitChild(this.defaultVal, v);
        return this.reconstruct(type, defVal);
    }

    @Override
    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        return tb.pushCode();
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tb.typeSystem();
        JL5ParsedClassType ct = (JL5ParsedClassType)tb.currentClass();
        if (ct == null) {
            return this;
        }
        Flags f = this.flags;
        f = f.Public().Abstract();
        AnnotationTypeElemInstance ai = ts.annotationElemInstance(this.position(), ct, f, ts.unknownType(this.position()), this.name(), this.defaultVal != null);
        ct.addAnnotationElem(ai);
        return this.annotationElemInstance(ai);
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.ai.isCanonical()) {
            return this;
        }
        if (!this.returnType().isDisambiguated()) {
            return this;
        }
        this.ai.setReturnType(this.returnType().type());
        return this;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        if (!ts.isValidAnnotationValueType(this.type().type())) {
            throw new SemanticException("The type: " + this.type() + " for the annotation element declaration " + this.name() + " must be a primitive, String, Class, enum type, annotation type or an array of one of these.", this.type().position());
        }
        if (this.type().type().equals(tc.context().currentClass())) {
            throw new SemanticException("Cyclic annotation element type: " + this.type(), this.type().position());
        }
        if (this.defaultVal != null) {
            Type defaultValType;
            if (this.defaultVal instanceof Expr) {
                defaultValType = ((Expr)this.defaultVal).type();
            } else if (this.defaultVal instanceof ElementValueArrayInit) {
                ElementValueArrayInit evai = (ElementValueArrayInit)this.defaultVal;
                defaultValType = evai.type();
            } else if (this.defaultVal instanceof AnnotationElem) {
                defaultValType = ((AnnotationElem)this.defaultVal).typeName().type();
            } else {
                throw new InternalCompilerError("Don't know how to deal with default value (" + this.defaultVal + ") of kind " + this.defaultVal.getClass(), this.defaultVal.position());
            }
            if (this.defaultVal instanceof ElementValueArrayInit) {
                ((ElementValueArrayInit)this.defaultVal).typeCheckElements(tc, this.type.type());
            } else if (!(ts.isImplicitCastValid(defaultValType, this.type.type()) || ts.equals(defaultValType, this.type.type()) || this.defaultVal instanceof Expr && ts.numericConversionValid(this.type.type(), tc.lang().constantValue((Expr)this.defaultVal, tc.lang())) || ts.isBaseCastValid(defaultValType, this.type.type()) || this.defaultVal instanceof Expr && ts.numericConversionBaseValid(this.type.type(), tc.lang().constantValue((Expr)this.defaultVal, tc.lang())))) {
                throw new SemanticException("The type of the default value: " + this.defaultVal + " does not match the annotation element type: " + this.type.type() + " .", this.defaultVal.position());
            }
        }
        if (this.flags.contains(Flags.NATIVE)) {
            throw new SemanticException("Modifier native is not allowed here", this.position());
        }
        if (this.flags.contains(Flags.PRIVATE)) {
            throw new SemanticException("Modifier private is not allowed here", this.position());
        }
        if (this.defaultVal != null) {
            ts.checkAnnotationValueConstant(this.defaultVal);
        }
        return this;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.defaultVal != null) {
            v.visitCFG(this.defaultVal, this, 0);
        }
        return succs;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        Flags f = this.flags();
        f = f.clearPublic();
        f = f.clearAbstract();
        w.write(f.translate());
        this.print(this.type, w, tr);
        w.write(" " + this.name.id() + "( )");
        if (this.defaultVal != null) {
            w.write(" default ");
            this.print(this.defaultVal, w, tr);
        }
        w.write(";");
        w.end();
    }

    @Override
    public String toString() {
        return this.flags.translate() + this.type + " " + this.name.id() + "()";
    }

    @Override
    public MemberInstance memberInstance() {
        return this.annotationElemInstance();
    }

    @Override
    public Term firstChild() {
        return this.type;
    }

    @Override
    public TypeNode returnType() {
        return this.type();
    }

    @Override
    public MethodDecl returnType(TypeNode returnType) {
        return this.type(returnType);
    }

    @Override
    public List<Formal> formals() {
        return Collections.emptyList();
    }

    @Override
    public MethodDecl formals(List<Formal> formals) {
        if (!formals.isEmpty()) {
            throw new InternalCompilerError("Shouldn't have an Annotation Elem with formals");
        }
        return this;
    }

    @Override
    public List<TypeNode> throwTypes() {
        return Collections.emptyList();
    }

    @Override
    public MethodDecl throwTypes(List<TypeNode> throwTypes) {
        if (!throwTypes.isEmpty()) {
            throw new InternalCompilerError("Shouldn't have an Annotation Elem with throw types");
        }
        return this;
    }

    @Override
    public MethodInstance methodInstance() {
        return this.annotationElemInstance();
    }

    @Override
    public MethodDecl methodInstance(MethodInstance mi) {
        return this.annotationElemInstance((AnnotationTypeElemInstance)mi);
    }

    @Override
    public ProcedureInstance procedureInstance() {
        return this.annotationElemInstance();
    }

    @Override
    public Block body() {
        return null;
    }

    @Override
    public CodeBlock body(Block body) {
        if (body != null) {
            throw new InternalCompilerError("Shouldn't have an Annotation Elem with a body");
        }
        return this;
    }

    @Override
    public Term codeBody() {
        return null;
    }

    @Override
    public CodeInstance codeInstance() {
        return this.annotationElemInstance();
    }
}

