/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import polyglot.ast.Block;
import polyglot.ast.Catch;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ast.Try;
import polyglot.ast.TryOps;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.util.SubtypeSet;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class Try_c
extends Stmt_c
implements Try,
TryOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Block tryBlock;
    protected List<Catch> catchBlocks;
    protected Block finallyBlock;

    public Try_c(Position pos, Block tryBlock, List<Catch> catchBlocks, Block finallyBlock) {
        this(pos, tryBlock, catchBlocks, finallyBlock, null);
    }

    public Try_c(Position pos, Block tryBlock, List<Catch> catchBlocks, Block finallyBlock, Ext ext) {
        super(pos, ext);
        this.assert_(pos, tryBlock, catchBlocks, finallyBlock);
        this.tryBlock = tryBlock;
        this.catchBlocks = ListUtil.copy(catchBlocks, true);
        this.finallyBlock = finallyBlock;
    }

    protected void assert_(Position pos, Block tryBlock, List<Catch> catchBlocks, Block finallyBlock) {
        assert (tryBlock != null && catchBlocks != null);
        assert (!catchBlocks.isEmpty() || finallyBlock != null);
    }

    @Override
    public Block tryBlock() {
        return this.tryBlock;
    }

    @Override
    public Try tryBlock(Block tryBlock) {
        return this.tryBlock(this, tryBlock);
    }

    protected <N extends Try_c> N tryBlock(N n, Block tryBlock) {
        if (n.tryBlock == tryBlock) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.tryBlock = tryBlock;
        return n;
    }

    @Override
    public List<Catch> catchBlocks() {
        return this.catchBlocks;
    }

    @Override
    public Try catchBlocks(List<Catch> catchBlocks) {
        return this.catchBlocks(this, catchBlocks);
    }

    protected <N extends Try_c> N catchBlocks(N n, List<Catch> catchBlocks) {
        if (CollectionUtil.equals(n.catchBlocks, catchBlocks)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.catchBlocks = ListUtil.copy(catchBlocks, true);
        return n;
    }

    @Override
    public Block finallyBlock() {
        return this.finallyBlock;
    }

    @Override
    public Try finallyBlock(Block finallyBlock) {
        return this.finallyBlock(this, finallyBlock);
    }

    protected <N extends Try_c> N finallyBlock(N n, Block finallyBlock) {
        if (n.finallyBlock == finallyBlock) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.finallyBlock = finallyBlock;
        return n;
    }

    protected <N extends Try_c> N reconstruct(N n, Block tryBlock, List<Catch> catchBlocks, Block finallyBlock) {
        n = this.tryBlock(n, tryBlock);
        n = this.catchBlocks(n, catchBlocks);
        n = this.finallyBlock(n, finallyBlock);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Block tryBlock = this.visitChild(this.tryBlock, v);
        List<Catch> catchBlocks = this.visitList(this.catchBlocks, v);
        Block finallyBlock = this.visitChild(this.finallyBlock, v);
        return this.reconstruct(this, tryBlock, catchBlocks, finallyBlock);
    }

    @Override
    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        ec = (ExceptionChecker)super.exceptionCheckEnter(ec);
        return ec.bypassChildren(this);
    }

    @Override
    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        ExceptionChecker ecTryBlockEntry = ec;
        if (this.finallyBlock != null && !this.finallyBlock.reachable()) {
            ecTryBlockEntry = ecTryBlockEntry.pushCatchAllThrowable();
        }
        ExceptionChecker ecTryBlock = ec.lang().constructTryBlockExceptionChecker(this, ecTryBlockEntry);
        Try_c n = this;
        Block tryBlock = ec.lang().exceptionCheckTryBlock(n, ecTryBlock);
        n = this.tryBlock(n, tryBlock);
        List<Catch> catchBlocks = ec.lang().exceptionCheckCatchBlocks(n, ecTryBlockEntry);
        n = this.catchBlocks(n, catchBlocks);
        Block finallyBlock = ec.lang().exceptionCheckFinallyBlock(n, ec);
        n = this.finallyBlock(n, finallyBlock);
        for (Type exc : ec.lang().throwTypes(n, ec.typeSystem())) {
            ec.throwsException(exc, this.position());
        }
        n = this.exceptions(n, ec.throwsSet());
        return n;
    }

    @Override
    public Block exceptionCheckTryBlock(ExceptionChecker ec) {
        return this.visitChild(this.tryBlock, ec.lang().constructTryBlockExceptionChecker(this, ec));
    }

    @Override
    public ExceptionChecker constructTryBlockExceptionChecker(ExceptionChecker ec) {
        ExceptionChecker newec = ec.push();
        ListIterator<Catch> i = this.catchBlocks.listIterator(this.catchBlocks.size());
        while (i.hasPrevious()) {
            Catch cb = i.previous();
            Type catchType = cb.catchType();
            newec = newec.push(catchType);
        }
        return newec;
    }

    @Override
    public List<Catch> exceptionCheckCatchBlocks(ExceptionChecker ec) throws SemanticException {
        SubtypeSet caught = new SubtypeSet(ec.typeSystem().Throwable());
        for (Catch cb : this.catchBlocks) {
            Type catchType = cb.catchType();
            if (caught.contains(catchType)) {
                throw new SemanticException("The exception \"" + catchType + "\" has been caught by an earlier catch block.", cb.position());
            }
            caught.add(catchType);
        }
        ArrayList<Catch> catchBlocks = new ArrayList<Catch>(this.catchBlocks.size());
        for (Catch cb : this.catchBlocks) {
            cb = this.visitChild(cb, ec.push());
            catchBlocks.add(cb);
        }
        return catchBlocks;
    }

    @Override
    public Block exceptionCheckFinallyBlock(ExceptionChecker ec) {
        if (this.finallyBlock == null) {
            return null;
        }
        Block fb = this.visitChild(this.finallyBlock, ec.push());
        if (!this.finallyBlock.reachable()) {
            // empty if block
        }
        return fb;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("try ");
        sb.append(this.tryBlock.toString());
        int count = 0;
        for (Catch cb : this.catchBlocks) {
            if (count++ > 2) {
                sb.append("...");
                break;
            }
            sb.append(" ");
            sb.append(cb.toString());
        }
        if (this.finallyBlock != null) {
            sb.append(" finally ");
            sb.append(this.finallyBlock.toString());
        }
        return sb.toString();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("try");
        this.printSubStmt(this.tryBlock, w, tr);
        for (Catch cb : this.catchBlocks) {
            w.newline(0);
            this.printBlock(cb, w, tr);
        }
        if (this.finallyBlock != null) {
            w.newline(0);
            w.write("finally");
            this.printSubStmt(this.finallyBlock, w, tr);
        }
    }

    @Override
    public Term firstChild() {
        return this.tryBlock;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        TypeSystem ts = v.typeSystem();
        CFGBuilder<?> v1 = v.push(this, false);
        CFGBuilder<?> v2 = v.push(this, true);
        for (Type type : ts.uncheckedExceptions()) {
            v1.visitThrow(this.tryBlock, 1, type);
        }
        if (this.finallyBlock != null) {
            v1.visitCFG(this.tryBlock, this.finallyBlock, 1);
            v.visitCFG(this.finallyBlock, this, 0);
        } else {
            v1.visitCFG(this.tryBlock, this, 0);
        }
        for (Catch cb : this.catchBlocks) {
            if (this.finallyBlock != null) {
                v2.visitCFG(cb, this.finallyBlock, 1);
                continue;
            }
            v2.visitCFG(cb, this, 0);
        }
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Try(this.position, this.tryBlock, this.catchBlocks, this.finallyBlock);
    }
}

