/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ast.Throw;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Throw_c
extends Stmt_c
implements Throw {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr expr;

    public Throw_c(Position pos, Expr expr) {
        this(pos, expr, null);
    }

    public Throw_c(Position pos, Expr expr, Ext ext) {
        super(pos, ext);
        assert (expr != null);
        this.expr = expr;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Throw expr(Expr expr) {
        return this.expr(this, expr);
    }

    protected <N extends Throw_c> N expr(N n, Expr expr) {
        if (n.expr == expr) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.expr = expr;
        return n;
    }

    protected <N extends Throw_c> N reconstruct(N n, Expr expr) {
        n = this.expr(n, expr);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr expr = this.visitChild(this.expr, v);
        return this.reconstruct(this, expr);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        if (!this.expr.type().isThrowable()) {
            throw new SemanticException("Can only throw subclasses of \"" + tc.typeSystem().Throwable() + "\".", this.expr.position());
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            return ts.Throwable();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "throw " + this.expr + ";";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("throw ");
        this.print(this.expr, w, tr);
        w.write(";");
    }

    @Override
    public Term firstChild() {
        return this.expr;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFG(this.expr, this, 0);
        return Collections.emptyList();
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        return CollectionUtil.list(this.expr.type(), ts.NullPointerException());
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Throw(this.position, this.expr);
    }
}

