/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Synchronized;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Synchronized_c
extends Stmt_c
implements Synchronized {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr expr;
    protected Block body;

    public Synchronized_c(Position pos, Expr expr, Block body) {
        this(pos, expr, body, null);
    }

    public Synchronized_c(Position pos, Expr expr, Block body, Ext ext) {
        super(pos, ext);
        assert (expr != null && body != null);
        this.expr = expr;
        this.body = body;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Synchronized expr(Expr expr) {
        return this.expr(this, expr);
    }

    protected <N extends Synchronized_c> N expr(N n, Expr expr) {
        if (n.expr == expr) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.expr = expr;
        return n;
    }

    @Override
    public Block body() {
        return this.body;
    }

    @Override
    public Synchronized body(Block body) {
        return this.body(this, body);
    }

    protected <N extends Synchronized_c> N body(N n, Block body) {
        if (n.body == body) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.body = body;
        return n;
    }

    protected <N extends Synchronized_c> N reconstruct(N n, Expr expr, Block body) {
        n = this.expr(n, expr);
        n = this.body(n, body);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr expr = this.visitChild(this.expr, v);
        Block body = this.visitChild(this.body, v);
        return this.reconstruct(this, expr, body);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        if (!this.expr.type().isReference()) {
            throw new SemanticException("Cannot synchronize on an expression of type \"" + this.expr.type() + "\".", this.expr.position());
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            return ts.Object();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "synchronized (" + this.expr + ") { ... }";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("synchronized (");
        this.printBlock(this.expr, w, tr);
        w.write(") ");
        this.printSubStmt(this.body, w, tr);
    }

    @Override
    public Term firstChild() {
        return this.expr;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFG(this.expr, this.body, 1);
        v.visitCFG(this.body, this, 0);
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Synchronized(this.position, this.expr, this.body);
    }
}

