/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.HashMap;
import java.util.List;
import polyglot.ast.ClassDecl;
import polyglot.ast.Ext;
import polyglot.ast.Import;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Node_c;
import polyglot.ast.PackageNode;
import polyglot.ast.SourceFile;
import polyglot.ast.TopLevelDecl;
import polyglot.frontend.Source;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.Context;
import polyglot.types.ImportTable;
import polyglot.types.Named;
import polyglot.types.Package;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class SourceFile_c
extends Node_c
implements SourceFile {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected PackageNode package_;
    protected List<Import> imports;
    protected List<TopLevelDecl> decls;
    protected ImportTable importTable;
    protected Source source;

    public SourceFile_c(Position pos, PackageNode package_, List<Import> imports, List<TopLevelDecl> decls) {
        this(pos, package_, imports, decls, null);
    }

    public SourceFile_c(Position pos, PackageNode package_, List<Import> imports, List<TopLevelDecl> decls, Ext ext) {
        super(pos, ext);
        assert (imports != null && decls != null);
        this.package_ = package_;
        this.imports = ListUtil.copy(imports, true);
        this.decls = ListUtil.copy(decls, true);
    }

    @Override
    public boolean isDisambiguated() {
        return super.isDisambiguated() && this.importTable != null;
    }

    @Override
    public Source source() {
        return this.source;
    }

    @Override
    public SourceFile source(Source source) {
        return this.source(this, source);
    }

    protected <N extends SourceFile_c> N source(N n, Source source) {
        if (n.source == source) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.source = source;
        return n;
    }

    @Override
    public PackageNode package_() {
        return this.package_;
    }

    @Override
    public SourceFile package_(PackageNode package_) {
        return this.package_(this, package_);
    }

    protected <N extends SourceFile_c> N package_(N n, PackageNode package_) {
        if (n.package_ == package_) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.package_ = package_;
        return n;
    }

    @Override
    public List<Import> imports() {
        return this.imports;
    }

    @Override
    public SourceFile imports(List<Import> imports) {
        return this.imports(this, imports);
    }

    protected <N extends SourceFile_c> N imports(N n, List<Import> imports) {
        if (CollectionUtil.equals(n.imports, imports)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.imports = ListUtil.copy(imports, true);
        return n;
    }

    @Override
    public List<TopLevelDecl> decls() {
        return this.decls;
    }

    @Override
    public SourceFile decls(List<TopLevelDecl> decls) {
        return this.decls(this, decls);
    }

    protected <N extends SourceFile_c> N decls(N n, List<TopLevelDecl> decls) {
        if (CollectionUtil.equals(n.decls, decls)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.decls = ListUtil.copy(decls, true);
        return n;
    }

    @Override
    public ImportTable importTable() {
        return this.importTable;
    }

    @Override
    public SourceFile importTable(ImportTable importTable) {
        return this.importTable(this, importTable);
    }

    protected <N extends SourceFile_c> N importTable(N n, ImportTable importTable) {
        if (n.importTable == importTable) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.importTable = importTable;
        return n;
    }

    protected <N extends SourceFile_c> N reconstruct(N n, PackageNode package_, List<Import> imports, List<TopLevelDecl> decls) {
        n = this.package_(n, package_);
        n = this.imports(n, imports);
        n = this.decls(n, decls);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        PackageNode package_ = this.visitChild(this.package_, v);
        List<Import> imports = this.visitList(this.imports, v);
        List<TopLevelDecl> decls = this.visitList(this.decls, v);
        return this.reconstruct(this, package_, imports, decls);
    }

    @Override
    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        Package pkg = null;
        if (this.package_ != null) {
            pkg = this.package_.package_();
        }
        ImportTable it = ts.importTable(this.source.name(), pkg);
        tb = tb.pushPackage(pkg);
        tb.setImportTable(it);
        return tb;
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        return this.importTable(tb.importTable());
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushSource(this.importTable);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HashMap<String, ParsedClassType> declaredTypes = new HashMap<String, ParsedClassType>();
        boolean hasPublic = false;
        for (TopLevelDecl d : this.decls) {
            String s = d.name();
            if (declaredTypes.containsKey(s)) {
                throw new SemanticException("Duplicate declaration: \"" + s + "\".", d.position());
            }
            declaredTypes.put(s, ((ClassDecl)d).type());
            if (!d.flags().isPublic()) continue;
            if (hasPublic) {
                throw new SemanticException("The source contains more than one public declaration.", d.position());
            }
            hasPublic = true;
        }
        TypeSystem ts = tc.typeSystem();
        HashMap<String, Named> importedTypes = new HashMap<String, Named>();
        for (Import i : this.imports) {
            Named declaredType;
            if (i.kind() != Import.SINGLE_TYPE) continue;
            String s = i.name();
            Named named = ts.forName(s);
            String name = named.name();
            if (importedTypes.containsKey(name)) {
                Named importedType = (Named)importedTypes.get(name);
                if (!ts.equals(named, importedType)) {
                    throw new SemanticException(name + " is already defined in a single-type import as type " + importedType + ".", i.position());
                }
            } else {
                importedTypes.put(name, named);
            }
            if (!declaredTypes.containsKey(name) || ts.equals(named, declaredType = (Named)declaredTypes.get(name))) continue;
            throw new SemanticException("The import " + s + " conflicts with type " + declaredType + " defined in the same file.", i.position());
        }
        return this;
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        SourceFile_c n = (SourceFile_c)super.extRewrite(rw);
        n = this.importTable(n, null);
        return n;
    }

    @Override
    public String toString() {
        return "<<<< " + this.source + " >>>>";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("<<<< " + this.source + " >>>>");
        w.newline(0);
        if (this.package_ != null) {
            w.write("package ");
            this.print(this.package_, w, tr);
            w.write(";");
            w.newline(0);
            w.newline(0);
        }
        for (Import im : this.imports) {
            this.print(im, w, tr);
        }
        if (!this.imports.isEmpty()) {
            w.newline(0);
        }
        for (TopLevelDecl d : this.decls) {
            this.print(d, w, tr);
        }
    }

    @Override
    public Node disambiguateOverride(Node parent, AmbiguityRemover ar) throws SemanticException {
        return null;
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        w.begin(0);
        w.allowBreak(4, " ");
        w.write("(import-table " + this.importTable + ")");
        w.end();
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.SourceFile(this.position, this.package_, this.imports, this.decls).source(this.source);
    }
}

