/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Node_c;
import polyglot.ast.SourceCollection;
import polyglot.ast.SourceFile;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class SourceCollection_c
extends Node_c
implements SourceCollection {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<SourceFile> sources;

    public SourceCollection_c(Position pos, List<SourceFile> sources) {
        this(pos, sources, null);
    }

    public SourceCollection_c(Position pos, List<SourceFile> sources, Ext ext) {
        super(pos, ext);
        assert (sources != null);
        this.sources = ListUtil.copy(sources, true);
    }

    @Override
    public String toString() {
        return this.sources.toString();
    }

    @Override
    public List<SourceFile> sources() {
        return this.sources;
    }

    @Override
    public SourceCollection sources(List<SourceFile> sources) {
        return this.sources(this, sources);
    }

    protected <N extends SourceCollection_c> N sources(N n, List<SourceFile> sources) {
        if (CollectionUtil.equals(n.sources, sources)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.sources = ListUtil.copy(sources, true);
        return n;
    }

    protected <N extends SourceCollection_c> N reconstruct(N n, List<SourceFile> sources) {
        n = this.sources(n, sources);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List<SourceFile> sources = this.visitList(this.sources, v);
        return this.reconstruct(this, sources);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        for (SourceFile s : this.sources) {
            this.print(s, w, tr);
            w.newline(0);
        }
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.SourceCollection(this.position, this.sources);
    }
}

