/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import polyglot.ast.Ambiguous;
import polyglot.ast.Block;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.JLDel;
import polyglot.ast.JLang;
import polyglot.ast.JLang_c;
import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.NodeOps;
import polyglot.ast.Stmt;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.util.StringUtil;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.ConstantChecker;
import polyglot.visit.DumpAst;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public abstract class Node_c
implements Node {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Position position;
    @Deprecated
    protected JLDel del;
    protected Ext ext;
    protected boolean error;

    @Deprecated
    public Node_c(Position pos) {
        this(pos, null);
    }

    public Node_c(Position pos, Ext ext) {
        assert (pos != null);
        this.position = pos;
        this.ext = ext;
        if (ext != null) {
            ext.init(this);
            ext.initPred(this);
        }
        this.error = false;
    }

    @Override
    @Deprecated
    public NodeOps del() {
        return this.del != null ? this.del : this;
    }

    @Override
    @Deprecated
    public Node del(JLDel del) {
        if (this.del == del) {
            return this;
        }
        JLDel old = this.del;
        this.del = null;
        Node_c n = (Node_c)this.copy();
        n.del = del;
        if (n.del != null) {
            n.del.init(n);
        }
        this.del = old;
        return n;
    }

    @Override
    public Ext ext(int n) {
        if (n < 1) {
            throw new InternalCompilerError("n must be >= 1");
        }
        if (n == 1) {
            return this.ext();
        }
        return this.ext(n - 1).ext();
    }

    @Override
    @Deprecated
    public Node ext(int n, Ext ext) {
        if (n < 1) {
            throw new InternalCompilerError("n must be >= 1");
        }
        if (n == 1) {
            return this.ext(ext);
        }
        Ext prev = this.ext(n - 1);
        if (prev == null) {
            throw new InternalCompilerError("cannot set the nth extension if there is no (n-1)st extension");
        }
        return this.ext(n - 1, prev.ext(ext));
    }

    @Override
    public Ext ext() {
        return this.ext;
    }

    @Override
    public Node ext(Ext ext) {
        if (this.ext == ext) {
            return this;
        }
        Ext old = this.ext;
        this.ext = null;
        Node_c n = (Node_c)this.copy();
        n.ext = ext;
        if (n.ext != null) {
            n.ext.init(n);
            n.ext.initPred(n);
        }
        this.ext = old;
        return n;
    }

    @Override
    public Node copy() {
        try {
            Node_c n = (Node_c)super.clone();
            if (this.del != null) {
                n.del = (JLDel)this.del.copy();
                n.del.init(n);
            }
            if (this.ext != null) {
                n.ext = (Ext)this.ext.copy();
                n.ext.init(n);
                n.ext.initPred(n);
            }
            return n;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness.");
        }
    }

    protected <N extends Node> N copyIfNeeded(N n) {
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        return n;
    }

    @Override
    public Position position() {
        return this.position;
    }

    @Override
    public Node position(Position position) {
        return this.position(this, position);
    }

    protected <N extends Node_c> N position(N n, Position position) {
        if (n.position == position) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.position = position;
        return n;
    }

    @Override
    public boolean isDisambiguated() {
        return !(this instanceof Ambiguous);
    }

    @Override
    public boolean isTypeChecked() {
        return this.isDisambiguated();
    }

    @Override
    public boolean error() {
        return this.error;
    }

    @Override
    public Node error(boolean flag) {
        return this.error(this, flag);
    }

    protected <N extends Node_c> N error(N n, boolean flag) {
        if (n.error == flag) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.error = flag;
        return n;
    }

    @Override
    public <N extends Node> N visitChild(N n, NodeVisitor v) {
        if (n == null) {
            return null;
        }
        return v.visitEdge(this, n);
    }

    @Override
    public Node visit(NodeVisitor v) {
        return v.visitEdge(null, this);
    }

    @Override
    @Deprecated
    public Node visitEdge(Node parent, NodeVisitor v) {
        Node n = v.override(parent, this);
        if (n == null) {
            NodeVisitor v_ = v.enter(parent, this);
            if (v_ == null) {
                throw new InternalCompilerError("NodeVisitor.enter() returned null.");
            }
            n = v.lang().visitChildren(this, v_);
            if (n == null) {
                throw new InternalCompilerError("Node_c.visitChildren() returned null.");
            }
            if ((n = v.leave(parent, this, n, v_)) == null) {
                throw new InternalCompilerError("NodeVisitor.leave() returned null.");
            }
        }
        return n;
    }

    public <T extends Node> List<T> visitList(List<T> l, NodeVisitor v) {
        if (l == null) {
            return null;
        }
        List<T> result = l;
        ArrayList<T> vl = new ArrayList<T>(l.size());
        for (Node n : l) {
            Node m;
            if (n != (m = this.visitChild(n, v))) {
                result = vl;
            }
            if (m == null) continue;
            Node t = m;
            vl.add(t);
        }
        return result;
    }

    @Override
    public final JLang lang() {
        return JLang_c.instance;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        return this;
    }

    @Override
    public Context enterScope(Context c) {
        return c;
    }

    @Override
    public Context enterChildScope(Node child, Context c) {
        return c.lang().enterScope(child, c);
    }

    @Override
    public void addDecls(Context c) {
    }

    @Override
    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        return tb;
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        return this;
    }

    @Override
    public Node disambiguateOverride(Node parent, AmbiguityRemover ar) throws SemanticException {
        return null;
    }

    @Override
    public NodeVisitor disambiguateEnter(AmbiguityRemover ar) throws SemanticException {
        return ar;
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        return this;
    }

    @Override
    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        return null;
    }

    @Override
    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        return tc;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        return this;
    }

    @Override
    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        return child.type();
    }

    @Override
    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return ec.push();
    }

    @Override
    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        List<Type> l = ec.lang().throwTypes(this, ec.typeSystem());
        for (Type exc : l) {
            ec.throwsException(exc, this.position());
        }
        return this;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        return Collections.emptyList();
    }

    @Override
    public NodeVisitor extRewriteEnter(ExtensionRewriter rw) throws SemanticException {
        return rw;
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        return this.copy(rw.to_nf());
    }

    @Override
    @Deprecated
    public void dump(OutputStream os) {
        CodeWriter cw = Compiler.createCodeWriter(os);
        NodeVisitor dumper = new DumpAst(cw);
        dumper = dumper.begin();
        this.visit(dumper);
        cw.newline();
        dumper.finish();
    }

    @Override
    public void dump(Lang lang, OutputStream os) {
        CodeWriter cw = Compiler.createCodeWriter(os);
        NodeVisitor dumper = new DumpAst(lang, cw);
        dumper = dumper.begin();
        this.visit(dumper);
        cw.newline();
        dumper.finish();
    }

    @Override
    @Deprecated
    public void dump(Writer w) {
        CodeWriter cw = Compiler.createCodeWriter(w);
        NodeVisitor dumper = new DumpAst(cw);
        dumper = dumper.begin();
        this.visit(dumper);
        cw.newline();
        dumper.finish();
    }

    @Override
    public void dump(Lang lang, Writer w) {
        CodeWriter cw = Compiler.createCodeWriter(w);
        NodeVisitor dumper = new DumpAst(lang, cw);
        dumper = dumper.begin();
        this.visit(dumper);
        cw.newline();
        dumper.finish();
    }

    @Override
    @Deprecated
    public void prettyPrint(OutputStream os) {
        try {
            CodeWriter cw = Compiler.createCodeWriter(os);
            this.del().prettyPrint(cw, new PrettyPrinter());
            cw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void prettyPrint(Lang lang, OutputStream os) {
        try {
            CodeWriter cw = Compiler.createCodeWriter(os);
            lang.prettyPrint((Node)this, cw, new PrettyPrinter(lang));
            cw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @Deprecated
    public void prettyPrint(Writer w) {
        try {
            CodeWriter cw = Compiler.createCodeWriter(w);
            this.del().prettyPrint(cw, new PrettyPrinter());
            cw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void prettyPrint(Lang lang, Writer w) {
        try {
            CodeWriter cw = Compiler.createCodeWriter(w);
            lang.prettyPrint((Node)this, cw, new PrettyPrinter(lang));
            cw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter pp) {
    }

    public void printBlock(Node n, CodeWriter w, PrettyPrinter pp) {
        w.begin(0);
        this.print(n, w, pp);
        w.end();
    }

    public void printSubStmt(Stmt stmt, CodeWriter w, PrettyPrinter pp) {
        if (stmt instanceof Block) {
            w.write(" ");
            this.print(stmt, w, pp);
        } else {
            w.allowBreak(4, " ");
            this.printBlock(stmt, w, pp);
        }
    }

    public void print(Node child, CodeWriter w, PrettyPrinter pp) {
        pp.print(this, child, w);
    }

    @Override
    public void translate(CodeWriter w, Translator tr) {
        tr.lang().prettyPrint((Node)this, w, tr);
    }

    @Override
    public void dump(CodeWriter w) {
        w.write(StringUtil.getShortNameComponent(this.getClass().getName()));
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(del ");
        if (this.del() == this) {
            w.write("*");
        } else {
            w.write(this.del().toString());
        }
        w.write(")");
        w.end();
        Ext ext = this.ext();
        do {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(ext ");
            if (ext == null) {
                w.write("null");
            } else {
                ext.dump(w);
            }
            w.write(")");
            w.end();
            if (ext == null) continue;
            ext = ext.ext();
        } while (ext != null);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(position " + (this.position != null ? this.position.toString() : "UNKNOWN") + ")");
        w.end();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(StringUtil.getShortNameComponent(this.getClass().getName()));
        if (this.ext != null) {
            sb.append(":");
            sb.append(this.ext.toString());
        }
        return sb.toString();
    }

    @Override
    public Node copy(NodeFactory nf) {
        throw new InternalCompilerError("Unimplemented operation. This class (" + this.getClass().getName() + ") does " + "not implement copy(NodeFactory). This compiler extension should" + " either implement the method, or not invoke this method.");
    }

    @Override
    public Node copy(ExtensionInfo extInfo) throws SemanticException {
        return extInfo.nodeFactory().lang().copy((Node)this, extInfo.nodeFactory());
    }
}

