/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Ext;
import polyglot.ast.Id;
import polyglot.ast.Labeled;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Labeled_c
extends Stmt_c
implements Labeled {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Id label;
    protected Stmt statement;

    public Labeled_c(Position pos, Id label, Stmt statement) {
        this(pos, label, statement, null);
    }

    public Labeled_c(Position pos, Id label, Stmt statement, Ext ext) {
        super(pos, ext);
        assert (label != null && statement != null);
        this.label = label;
        this.statement = statement;
    }

    @Override
    public Id labelNode() {
        return this.label;
    }

    @Override
    public Labeled labelNode(Id label) {
        return this.labelNode(this, label);
    }

    protected <N extends Labeled_c> N labelNode(N n, Id label) {
        if (n.label == label) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.label = label;
        return n;
    }

    @Override
    public String label() {
        return this.label.id();
    }

    @Override
    public Labeled label(String label) {
        return this.labelNode(this.label.id(label));
    }

    @Override
    public Stmt statement() {
        return this.statement;
    }

    @Override
    public Labeled statement(Stmt statement) {
        return this.statement(this, statement);
    }

    protected <N extends Labeled_c> N statement(N n, Stmt statement) {
        if (n.statement == statement) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.statement = statement;
        return n;
    }

    protected <N extends Labeled_c> N reconstruct(N n, Id label, Stmt statement) {
        n = this.labelNode(n, label);
        n = this.statement(n, statement);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Id label = this.visitChild(this.label, v);
        Stmt statement = this.visitChild(this.statement, v);
        return this.reconstruct(this, label, statement);
    }

    @Override
    public String toString() {
        return this.label + ": " + this.statement;
    }

    @Override
    public Context enterChildScope(Node child, Context c) {
        c = c.pushLabel(this.label.id());
        return super.enterChildScope(child, c);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Context c = tc.context();
        String outerLabel = c.findLabelSilent(this.label.id());
        if (outerLabel != null && outerLabel.equals(this.label.id())) {
            throw new SemanticException("Label \"" + this.label + "\" already in use.");
        }
        return super.typeCheck(tc);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.label + ": ");
        this.print(this.statement, w, tr);
    }

    @Override
    public Term firstChild() {
        return this.statement;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.push(this).visitCFG(this.statement, this, 0);
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Labeled(this.position, this.label, this.statement);
    }
}

