/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.Instanceof;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Instanceof_c
extends Expr_c
implements Instanceof {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr expr;
    protected TypeNode compareType;

    public Instanceof_c(Position pos, Expr expr, TypeNode compareType) {
        this(pos, expr, compareType, null);
    }

    public Instanceof_c(Position pos, Expr expr, TypeNode compareType, Ext ext) {
        super(pos, ext);
        assert (expr != null && compareType != null);
        this.expr = expr;
        this.compareType = compareType;
    }

    @Override
    public Precedence precedence() {
        return Precedence.INSTANCEOF;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Instanceof expr(Expr expr) {
        return this.expr(this, expr);
    }

    protected <N extends Instanceof_c> N expr(N n, Expr expr) {
        if (n.expr == expr) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.expr = expr;
        return n;
    }

    @Override
    public TypeNode compareType() {
        return this.compareType;
    }

    @Override
    public Instanceof compareType(TypeNode compareType) {
        return this.compareType(this, compareType);
    }

    protected <N extends Instanceof_c> N compareType(N n, TypeNode compareType) {
        if (n.compareType == compareType) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.compareType = compareType;
        return n;
    }

    protected <N extends Instanceof_c> N reconstruct(N n, Expr expr, TypeNode compareType) {
        n = this.expr(n, expr);
        n = this.compareType(n, compareType);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr expr = this.visitChild(this.expr, v);
        TypeNode compareType = this.visitChild(this.compareType, v);
        return this.reconstruct(this, expr, compareType);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!this.compareType.type().isReference()) {
            throw new SemanticException("Type operand " + this.compareType.type() + " must be a reference type.", this.compareType.position());
        }
        if (!ts.isCastValid(this.expr.type(), this.compareType.type())) {
            throw new SemanticException("Expression operand type " + this.expr.type() + " is incompatible with type operand " + this.compareType.type() + ".", this.expr.position());
        }
        return this.type(ts.Boolean());
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            return ts.Object();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return this.expr + " instanceof " + this.compareType;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printSubExpr(this.expr, w, tr);
        w.write(" instanceof ");
        this.print(this.compareType, w, tr);
    }

    @Override
    public Term firstChild() {
        return this.expr;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFG(this.expr, this.compareType, 1);
        v.visitCFG(this.compareType, this, 0);
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Instanceof(this.position, this.expr, this.compareType);
    }
}

