/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.Id;
import polyglot.ast.JLang;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.InitializerInstance;
import polyglot.types.MemberInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ConstantChecker;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.PruningVisitor;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class FieldDecl_c
extends Term_c
implements FieldDecl {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Flags flags;
    protected TypeNode type;
    protected Id name;
    protected Expr init;
    protected FieldInstance fi;
    protected InitializerInstance ii;

    public FieldDecl_c(Position pos, Flags flags, TypeNode type, Id name, Expr init) {
        this(pos, flags, type, name, init, null);
    }

    public FieldDecl_c(Position pos, Flags flags, TypeNode type, Id name, Expr init, Ext ext) {
        super(pos, ext);
        assert (flags != null && type != null && name != null);
        this.flags = flags;
        this.type = type;
        this.name = name;
        this.init = init;
    }

    @Override
    public boolean isDisambiguated() {
        return this.fi != null && this.fi.isCanonical() && (this.init == null || this.ii != null && this.ii.isCanonical()) && super.isDisambiguated();
    }

    @Override
    public MemberInstance memberInstance() {
        return this.fieldInstance();
    }

    @Override
    public VarInstance varInstance() {
        return this.fieldInstance();
    }

    @Override
    public CodeInstance codeInstance() {
        return this.initializerInstance();
    }

    @Override
    public InitializerInstance initializerInstance() {
        return this.ii;
    }

    @Override
    public FieldDecl initializerInstance(InitializerInstance ii) {
        return this.initializerInstance(this, ii);
    }

    protected <N extends FieldDecl_c> N initializerInstance(N n, InitializerInstance ii) {
        if (n.ii == ii) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.ii = ii;
        return n;
    }

    @Override
    public Type declType() {
        return this.type.type();
    }

    @Override
    public Flags flags() {
        return this.flags;
    }

    @Override
    public FieldDecl flags(Flags flags) {
        return this.flags(this, flags);
    }

    protected <N extends FieldDecl_c> N flags(N n, Flags flags) {
        if (n.flags.equals(flags)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.flags = flags;
        return n;
    }

    @Override
    public TypeNode type() {
        return this.type;
    }

    @Override
    public FieldDecl type(TypeNode type) {
        return this.type(this, type);
    }

    protected <N extends FieldDecl_c> N type(N n, TypeNode type) {
        if (n.type == type) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.type = type;
        return n;
    }

    @Override
    public Id id() {
        return this.name;
    }

    @Override
    public FieldDecl id(Id name) {
        return this.id(this, name);
    }

    protected <N extends FieldDecl_c> N id(N n, Id name) {
        if (n.name == name) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.name = name;
        return n;
    }

    @Override
    public String name() {
        return this.name.id();
    }

    @Override
    public FieldDecl name(String name) {
        return this.id(this.name.id(name));
    }

    @Override
    public Term codeBody() {
        return this.init();
    }

    @Override
    public Expr init() {
        return this.init;
    }

    @Override
    public FieldDecl init(Expr init) {
        return this.init(this, init);
    }

    protected <N extends FieldDecl_c> N init(N n, Expr init) {
        if (n.init == init) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.init = init;
        return n;
    }

    @Override
    public FieldInstance fieldInstance() {
        return this.fi;
    }

    @Override
    public FieldDecl fieldInstance(FieldInstance fi) {
        return this.fieldInstance(this, fi);
    }

    protected <N extends FieldDecl_c> N fieldInstance(N n, FieldInstance fi) {
        if (n.fi == fi) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.fi = fi;
        return n;
    }

    protected <N extends FieldDecl_c> N reconstruct(N n, TypeNode type, Id name, Expr init) {
        n = this.type(n, type);
        n = this.id(n, name);
        n = this.init(n, init);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode type = this.visitChild(this.type, v);
        Id name = this.visitChild(this.name, v);
        Expr init = this.visitChild(this.init, v);
        return this.reconstruct(this, type, name, init);
    }

    @Override
    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        return tb.pushCode();
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        ParsedClassType ct = tb.currentClass();
        if (ct == null) {
            return this;
        }
        Flags f = this.flags;
        if (ct.flags().isInterface()) {
            f = f.Public().Static().Final();
        }
        FieldDecl_c n = this;
        if (this.init != null) {
            Flags iflags = f.isStatic() ? Flags.STATIC : Flags.NONE;
            InitializerInstance ii = ts.initializerInstance(this.init.position(), ct, iflags);
            n = this.initializerInstance(n, ii);
        }
        FieldInstance fi = ts.fieldInstance(this.position(), ct, f, ts.unknownType(this.position()), this.name.id());
        ct.addField(fi);
        n = this.flags(n, f);
        n = this.fieldInstance(n, fi);
        return n;
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.fi.isCanonical()) {
            return this;
        }
        if (this.declType().isCanonical()) {
            this.fi.setType(this.declType());
        }
        return this;
    }

    @Override
    public Context enterScope(Context c) {
        if (this.ii != null) {
            return c.pushCode(this.ii);
        }
        return c;
    }

    @Override
    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        if (this.init == null || !this.fi.flags().isFinal()) {
            this.fi.setNotConstant();
            return this;
        }
        if (!cc.lang().isConstant(this.init, cc.lang())) {
            this.fi.setNotConstant();
        } else {
            this.fi.setConstantValue(cc.lang().constantValue(this.init, cc.lang()));
        }
        return this;
    }

    @Override
    public boolean constantValueSet() {
        return this.fi != null && this.fi.constantValueSet();
    }

    @Override
    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        FieldDecl nn = this;
        FieldDecl_c old = this;
        NodeVisitor childv = tc.enter(parent, this);
        if (childv instanceof PruningVisitor) {
            return nn;
        }
        boolean constantValueSet = false;
        FieldInstance fi = nn.fieldInstance();
        if (fi.constantValueSet()) {
            constantValueSet = true;
        }
        TypeChecker childtc = (TypeChecker)childv;
        nn = (FieldDecl)tc.lang().visitChildren(nn, childtc);
        nn = (FieldDecl)tc.leave(parent, old, nn, childtc);
        if (!constantValueSet) {
            ConstantChecker cc = new ConstantChecker(tc.job(), tc.typeSystem(), tc.nodeFactory());
            cc = (ConstantChecker)cc.context(childtc.context());
            nn = (FieldDecl)tc.lang().checkConstants(nn, cc);
        }
        return nn;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Flags flags = this.fi.flags();
        try {
            ts.checkFieldFlags(flags);
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        if (tc.context().currentClass().flags().isInterface() && (flags.isProtected() || flags.isPrivate())) {
            throw new SemanticException("Interface members must be public.", this.position());
        }
        if (this.init != null) {
            if (this.init instanceof ArrayInit) {
                ((ArrayInit)this.init).typeCheckElements(tc, this.type.type());
            } else if (!(ts.isImplicitCastValid(this.init.type(), this.type.type()) || ts.typeEquals(this.init.type(), this.type.type()) || ts.numericConversionValid(this.type.type(), tc.lang().constantValue(this.init, tc.lang())))) {
                throw new SemanticException("The type of the variable initializer \"" + this.init.type() + "\" does not match that of " + "the declaration \"" + this.type.type() + "\".", this.init.position());
            }
        }
        if (this.flags().isStatic() && this.fieldInstance().container().toClass().isInnerClass() && (!this.flags().isFinal() || this.init == null || !tc.lang().isConstant(this.init, tc.lang()))) {
            throw new SemanticException("Inner classes cannot declare static fields, unless they are compile-time constant fields.", this.position());
        }
        return this;
    }

    @Override
    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return ec.push(new ExceptionChecker.CodeTypeReporter("field initializer"));
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.init) {
            return this.type.type();
        }
        return child.type();
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        FieldDecl_c n = (FieldDecl_c)super.extRewrite(rw);
        n = this.fieldInstance(n, null);
        n = this.initializerInstance(n, null);
        return n;
    }

    @Override
    public Term firstChild() {
        return this.type;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.init != null) {
            v.visitCFG(this.type, this.init, 1);
            v.visitCFG(this.init, this, 0);
        } else {
            v.visitCFG(this.type, this, 0);
        }
        return succs;
    }

    @Override
    public String toString() {
        return this.flags.translate() + this.type + " " + this.name + (this.init != null ? " = " + this.init : "");
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        boolean isInterface = this.fi != null && this.fi.container() != null && this.fi.container().toClass().flags().isInterface();
        Flags f = this.flags;
        if (isInterface) {
            f = f.clearPublic();
            f = f.clearStatic();
            f = f.clearFinal();
        }
        w.write(f.translate());
        this.print(this.type, w, tr);
        w.allowBreak(2, 2, " ", 1);
        tr.print(this, this.name, w);
        if (this.init != null) {
            w.write(" =");
            w.allowBreak(2, " ");
            this.print(this.init, w, tr);
        }
        w.write(";");
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.fi != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.fi + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.FieldDecl(this.position, this.flags, this.type, this.name, this.init);
    }

    public static class AddDependenciesVisitor
    extends NodeVisitor {
        protected Scheduler scheduler;
        protected FieldInstance fi;

        AddDependenciesVisitor(JLang lang, Scheduler scheduler, FieldInstance fi) {
            super(lang);
            this.scheduler = scheduler;
            this.fi = fi;
        }

        @Override
        public Node leave(Node old, Node n, NodeVisitor v) {
            Field f;
            if (n instanceof Field && !(f = (Field)n).fieldInstance().orig().constantValueSet()) {
                Goal newGoal = this.scheduler.FieldConstantsChecked(f.fieldInstance().orig());
                Goal myGoal = this.scheduler.FieldConstantsChecked(this.fi);
                for (Goal g : newGoal.prerequisiteGoals(this.scheduler)) {
                    if (!this.scheduler.prerequisiteDependsOn(g, myGoal)) continue;
                    this.fi.setNotConstant();
                    return n;
                }
                throw new MissingDependencyException(newGoal, true);
            }
            return n;
        }
    }
}

