/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Conditional;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Conditional_c
extends Expr_c
implements Conditional {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr cond;
    protected Expr consequent;
    protected Expr alternative;

    public Conditional_c(Position pos, Expr cond, Expr consequent, Expr alternative) {
        this(pos, cond, consequent, alternative, null);
    }

    public Conditional_c(Position pos, Expr cond, Expr consequent, Expr alternative, Ext ext) {
        super(pos, ext);
        assert (cond != null && consequent != null && alternative != null);
        this.cond = cond;
        this.consequent = consequent;
        this.alternative = alternative;
    }

    @Override
    public Precedence precedence() {
        return Precedence.CONDITIONAL;
    }

    @Override
    public Expr cond() {
        return this.cond;
    }

    @Override
    public Conditional cond(Expr cond) {
        return this.cond(this, cond);
    }

    protected <N extends Conditional_c> N cond(N n, Expr cond) {
        if (n.cond == cond) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.cond = cond;
        return n;
    }

    @Override
    public Expr consequent() {
        return this.consequent;
    }

    @Override
    public Conditional consequent(Expr consequent) {
        return this.consequent(this, consequent);
    }

    protected <N extends Conditional_c> N consequent(N n, Expr consequent) {
        if (n.consequent == consequent) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.consequent = consequent;
        return n;
    }

    @Override
    public Expr alternative() {
        return this.alternative;
    }

    @Override
    public Conditional alternative(Expr alternative) {
        return this.alternative(this, alternative);
    }

    protected <N extends Conditional_c> N alternative(N n, Expr alternative) {
        if (n.alternative == alternative) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.alternative = alternative;
        return n;
    }

    protected <N extends Conditional_c> N reconstruct(N n, Expr cond, Expr consequent, Expr alternative) {
        n = this.cond(n, cond);
        n = this.consequent(n, consequent);
        n = this.alternative(n, alternative);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr cond = this.visitChild(this.cond, v);
        Expr consequent = this.visitChild(this.consequent, v);
        Expr alternative = this.visitChild(this.alternative, v);
        return this.reconstruct(this, cond, consequent, alternative);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Expr e1 = this.consequent;
        Expr e2 = this.alternative;
        Type t1 = e1.type();
        Type t2 = e2.type();
        if (!ts.typeEquals(this.cond.type(), ts.Boolean())) {
            throw new SemanticException("Condition of ternary expression must be of type boolean.", this.cond.position());
        }
        if (ts.typeEquals(t1, t2)) {
            return this.type(t1);
        }
        if (t1.isNumeric() && t2.isNumeric()) {
            if (t1.isByte() && t2.isShort() || t1.isShort() && t2.isByte()) {
                return this.type(ts.Short());
            }
            if (t1.isIntOrLess() && t2.isInt() && ts.numericConversionValid(t1, tc.lang().constantValue(e2, tc.lang()))) {
                return this.type(t1);
            }
            if (t2.isIntOrLess() && t1.isInt() && ts.numericConversionValid(t2, tc.lang().constantValue(e1, tc.lang()))) {
                return this.type(t2);
            }
            return this.type(ts.promote(t1, t2));
        }
        if (t1.isNull() && t2.isReference()) {
            return this.type(t2);
        }
        if (t2.isNull() && t1.isReference()) {
            return this.type(t1);
        }
        if (t1.isReference() && t2.isReference()) {
            if (ts.isImplicitCastValid(t1, t2)) {
                return this.type(t2);
            }
            if (ts.isImplicitCastValid(t2, t1)) {
                return this.type(t1);
            }
        }
        throw new SemanticException("Could not determine type of ternary conditional expression; cannot assign " + t1 + " to " + t2 + " or vice versa.", this.position());
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.cond) {
            return ts.Boolean();
        }
        if (child == this.consequent || child == this.alternative) {
            return this.type();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return this.cond + " ? " + this.consequent + " : " + this.alternative;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printSubExpr(this.cond, false, w, tr);
        w.unifiedBreak(2);
        w.write("? ");
        this.printSubExpr(this.consequent, false, w, tr);
        w.unifiedBreak(2);
        w.write(": ");
        this.printSubExpr(this.alternative, false, w, tr);
    }

    @Override
    public Term firstChild() {
        return this.cond;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        boolean isBoolean = this.type.isBoolean();
        if (v.lang().isConstant(this.cond, v.lang())) {
            boolean condConstantValue = (Boolean)v.lang().constantValue(this.cond, v.lang());
            if (condConstantValue) {
                v.visitCFG((Term)this.cond, FlowGraph.EDGE_KEY_TRUE, this.consequent, 1);
                if (isBoolean) {
                    v.visitCFG(this.consequent, FlowGraph.EDGE_KEY_TRUE, this, 0, FlowGraph.EDGE_KEY_FALSE, this, 0);
                } else {
                    v.visitCFG(this.consequent, this, 0);
                }
            } else {
                v.visitCFG((Term)this.cond, FlowGraph.EDGE_KEY_FALSE, this.alternative, 1);
                if (isBoolean) {
                    v.visitCFG(this.alternative, FlowGraph.EDGE_KEY_TRUE, this, 0, FlowGraph.EDGE_KEY_FALSE, this, 0);
                } else {
                    v.visitCFG(this.alternative, this, 0);
                }
            }
        } else {
            v.visitCFG(this.cond, FlowGraph.EDGE_KEY_TRUE, this.consequent, 1, FlowGraph.EDGE_KEY_FALSE, this.alternative, 1);
            if (isBoolean) {
                v.visitCFG(this.consequent, FlowGraph.EDGE_KEY_TRUE, this, 0, FlowGraph.EDGE_KEY_FALSE, this, 0);
                v.visitCFG(this.alternative, FlowGraph.EDGE_KEY_TRUE, this, 0, FlowGraph.EDGE_KEY_FALSE, this, 0);
            } else {
                v.visitCFG(this.consequent, this, 0);
                v.visitCFG(this.alternative, this, 0);
            }
        }
        return succs;
    }

    @Override
    public boolean isConstant(Lang lang) {
        return lang.isConstant(this.cond, lang) && lang.isConstant(this.consequent, lang) && lang.isConstant(this.alternative, lang);
    }

    @Override
    public Object constantValue(Lang lang) {
        Object cond_ = lang.constantValue(this.cond, lang);
        Object then_ = lang.constantValue(this.consequent, lang);
        Object else_ = lang.constantValue(this.alternative, lang);
        if (cond_ instanceof Boolean && then_ != null && else_ != null) {
            boolean c = (Boolean)cond_;
            if (c) {
                return then_;
            }
            return else_;
        }
        return null;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Conditional(this.position, this.cond, this.consequent, this.alternative);
    }
}

