/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassMember;
import polyglot.ast.CodeDecl;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class ClassBody_c
extends Term_c
implements ClassBody {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<ClassMember> members;

    public ClassBody_c(Position pos, List<ClassMember> members) {
        this(pos, members, null);
    }

    public ClassBody_c(Position pos, List<ClassMember> members, Ext ext) {
        super(pos, ext);
        assert (members != null);
        this.members = ListUtil.copy(members, true);
    }

    @Override
    public List<ClassMember> members() {
        return this.members;
    }

    @Override
    public ClassBody members(List<ClassMember> members) {
        return this.members(this, members);
    }

    protected <N extends ClassBody_c> N members(N n, List<ClassMember> members) {
        if (CollectionUtil.equals(n.members, members)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.members = ListUtil.copy(members, true);
        return n;
    }

    @Override
    public ClassBody addMember(ClassMember member) {
        ArrayList<ClassMember> l = new ArrayList<ClassMember>(this.members.size() + 1);
        l.addAll(this.members);
        l.add(member);
        return this.members(l);
    }

    protected <N extends ClassBody_c> N reconstruct(N n, List<ClassMember> members) {
        n = this.members(n, members);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List<ClassMember> members = this.visitList(this.members, v);
        return this.reconstruct(this, members);
    }

    @Override
    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        return tb.enterAnonClass();
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        return this;
    }

    @Override
    public String toString() {
        return "{ ... }";
    }

    protected void duplicateFieldCheck(TypeChecker tc) throws SemanticException {
        ClassType type = tc.context().currentClass();
        ArrayList<? extends FieldInstance> l = new ArrayList<FieldInstance>(type.fields());
        for (int i = 0; i < l.size(); ++i) {
            FieldInstance fi = (FieldInstance)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                FieldInstance fj = (FieldInstance)l.get(j);
                if (!fi.name().equals(fj.name())) continue;
                throw new SemanticException("Duplicate field \"" + fj + "\".", fj.position());
            }
        }
    }

    protected void duplicateConstructorCheck(TypeChecker tc) throws SemanticException {
        ClassType type = tc.context().currentClass();
        ArrayList<? extends ConstructorInstance> l = new ArrayList<ConstructorInstance>(type.constructors());
        for (int i = 0; i < l.size(); ++i) {
            ConstructorInstance ci = (ConstructorInstance)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                ConstructorInstance cj = (ConstructorInstance)l.get(j);
                if (!ci.hasFormals(cj.formalTypes())) continue;
                throw new SemanticException("Duplicate constructor \"" + cj + "\".", cj.position());
            }
        }
    }

    protected void duplicateMethodCheck(TypeChecker tc) throws SemanticException {
        ClassType type = tc.context().currentClass();
        TypeSystem ts = tc.typeSystem();
        ArrayList<? extends MethodInstance> l = new ArrayList<MethodInstance>(type.methods());
        for (int i = 0; i < l.size(); ++i) {
            MethodInstance mi = (MethodInstance)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                MethodInstance mj = (MethodInstance)l.get(j);
                if (!this.isSameMethod(ts, mi, mj)) continue;
                throw new SemanticException("Duplicate method \"" + mj + "\".", mj.position());
            }
        }
    }

    protected void duplicateMemberClassCheck(TypeChecker tc) throws SemanticException {
        ClassType type = tc.context().currentClass();
        ArrayList<? extends ClassType> l = new ArrayList<ClassType>(type.memberClasses());
        for (int i = 0; i < l.size(); ++i) {
            ClassType mi = (ClassType)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                ClassType mj = (ClassType)l.get(j);
                if (!mi.name().equals(mj.name())) continue;
                throw new SemanticException("Duplicate member type \"" + mj + "\".", mj.position());
            }
        }
    }

    protected boolean isSameMethod(TypeSystem ts, MethodInstance mi, MethodInstance mj) {
        return mi.isSameMethod(mj);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        this.duplicateFieldCheck(tc);
        this.duplicateConstructorCheck(tc);
        this.duplicateMethodCheck(tc);
        this.duplicateMemberClassCheck(tc);
        return this;
    }

    @Override
    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return ec.push();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (!this.members.isEmpty()) {
            w.newline(4);
            w.begin(0);
            ClassMember prev = null;
            Iterator<ClassMember> i = this.members.iterator();
            while (i.hasNext()) {
                ClassMember member = i.next();
                if (member instanceof CodeDecl || prev instanceof CodeDecl) {
                    w.newline(0);
                }
                prev = member;
                this.printBlock(member, w, tr);
                if (!i.hasNext()) continue;
                w.newline(0);
            }
            w.end();
            w.newline(0);
        }
    }

    @Override
    public Term firstChild() {
        return null;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.ClassBody(this.position, this.members);
    }
}

