/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.ast.Variable;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public abstract class Assign_c
extends Expr_c
implements Assign {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr left;
    protected Assign.Operator op;
    protected Expr right;

    @Deprecated
    public Assign_c(Position pos, Expr left, Assign.Operator op, Expr right) {
        this(pos, left, op, right, null);
    }

    public Assign_c(Position pos, Expr left, Assign.Operator op, Expr right, Ext ext) {
        super(pos, ext);
        assert (left != null && op != null && right != null);
        this.left = left;
        this.op = op;
        this.right = right;
    }

    @Override
    public Precedence precedence() {
        return Precedence.ASSIGN;
    }

    @Override
    public Expr left() {
        return this.left;
    }

    @Override
    public Assign left(Expr left) {
        return this.left(this, left);
    }

    protected <N extends Assign_c> N left(N n, Expr left) {
        if (n.left == left) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.left = left;
        return n;
    }

    @Override
    public Assign.Operator operator() {
        return this.op;
    }

    @Override
    public Assign operator(Assign.Operator op) {
        return this.operator(this, op);
    }

    protected <N extends Assign_c> N operator(N n, Assign.Operator op) {
        if (n.op == op) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.op = op;
        return n;
    }

    @Override
    public Expr right() {
        return this.right;
    }

    @Override
    public Assign right(Expr right) {
        return this.right(this, right);
    }

    protected <N extends Assign_c> N right(N n, Expr right) {
        if (n.right == right) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.right = right;
        return n;
    }

    protected <N extends Assign_c> N reconstruct(N n, Expr left, Expr right) {
        n = this.left(n, left);
        n = this.right(n, right);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr left = this.visitChild(this.left, v);
        Expr right = this.visitChild(this.right, v);
        return this.reconstruct(this, left, right);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Type t = this.left.type();
        Type s = this.right.type();
        TypeSystem ts = tc.typeSystem();
        if (!(this.left instanceof Variable)) {
            throw new SemanticException("Target of assignment must be a variable.", this.position());
        }
        if (this.op == ASSIGN) {
            if (!(ts.isImplicitCastValid(s, t) || ts.typeEquals(s, t) || ts.numericConversionValid(t, tc.lang().constantValue(this.right, tc.lang())))) {
                throw new SemanticException("Cannot assign " + s + " to " + t + ".", this.position());
            }
            return this.type(t);
        }
        if (this.op == ADD_ASSIGN) {
            if (ts.typeEquals(t, ts.String()) && ts.canCoerceToString(s, tc.context())) {
                return this.type(ts.String());
            }
            if (t.isNumeric() && s.isNumeric()) {
                return this.type(ts.promote(t, s));
            }
            throw new SemanticException("The " + this.op + " operator must have " + "numeric or String operands.", this.position());
        }
        if (this.op == SUB_ASSIGN || this.op == MUL_ASSIGN || this.op == DIV_ASSIGN || this.op == MOD_ASSIGN) {
            if (t.isNumeric() && s.isNumeric()) {
                return this.type(ts.promote(t, s));
            }
            throw new SemanticException("The " + this.op + " operator must have " + "numeric operands.", this.position());
        }
        if (this.op == BIT_AND_ASSIGN || this.op == BIT_OR_ASSIGN || this.op == BIT_XOR_ASSIGN) {
            if (t.isBoolean() && s.isBoolean()) {
                return this.type(ts.Boolean());
            }
            if (ts.isImplicitCastValid(t, ts.Long()) && ts.isImplicitCastValid(s, ts.Long())) {
                return this.type(ts.promote(t, s));
            }
            throw new SemanticException("The " + this.op + " operator must have " + "integral or boolean operands.", this.position());
        }
        if (this.op == SHL_ASSIGN || this.op == SHR_ASSIGN || this.op == USHR_ASSIGN) {
            if (ts.isImplicitCastValid(t, ts.Long()) && ts.isImplicitCastValid(s, ts.Long())) {
                return this.type(ts.promote(t));
            }
            throw new SemanticException("The " + this.op + " operator must have " + "integral operands.", this.position());
        }
        throw new InternalCompilerError("Unrecognized assignment operator " + this.op + ".");
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.left) {
            return child.type();
        }
        TypeSystem ts = av.typeSystem();
        if (this.op == ASSIGN) {
            return this.left.type();
        }
        if (this.op == ADD_ASSIGN && ts.typeEquals(ts.String(), this.left.type())) {
            return child.type();
        }
        if (this.op == ADD_ASSIGN || this.op == SUB_ASSIGN || this.op == MUL_ASSIGN || this.op == DIV_ASSIGN || this.op == MOD_ASSIGN || this.op == SHL_ASSIGN || this.op == SHR_ASSIGN || this.op == USHR_ASSIGN) {
            if (this.left.type().isNumeric() && this.right.type().isNumeric()) {
                try {
                    return ts.promote(this.left.type(), child.type());
                }
                catch (SemanticException e) {
                    throw new InternalCompilerError(e);
                }
            }
            return child.type();
        }
        if (this.op == BIT_AND_ASSIGN || this.op == BIT_OR_ASSIGN || this.op == BIT_XOR_ASSIGN) {
            if (this.left.type().isBoolean()) {
                return ts.Boolean();
            }
            if (this.left.type().isNumeric() && this.right.type().isNumeric()) {
                try {
                    return ts.promote(this.left.type(), child.type());
                }
                catch (SemanticException e) {
                    throw new InternalCompilerError(e);
                }
            }
            return child.type();
        }
        throw new InternalCompilerError("Unrecognized assignment operator " + this.op + ".");
    }

    @Override
    public boolean throwsArithmeticException() {
        return this.op == DIV_ASSIGN || this.op == MOD_ASSIGN;
    }

    @Override
    public String toString() {
        return this.left + " " + this.op + " " + this.right;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printSubExpr(this.left, true, w, tr);
        w.write(" ");
        w.write(this.op.toString());
        w.allowBreak(2, 2, " ", 1);
        w.begin(0);
        this.printSubExpr(this.right, false, w, tr);
        w.end();
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(operator " + this.op + ")");
        w.end();
    }

    @Override
    public abstract Term firstChild();

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.operator() == ASSIGN) {
            this.acceptCFGAssign(v);
        } else {
            this.acceptCFGOpAssign(v);
        }
        return succs;
    }

    protected abstract void acceptCFGAssign(CFGBuilder<?> var1);

    protected abstract void acceptCFGOpAssign(CFGBuilder<?> var1);

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        LinkedList<Type> l = new LinkedList<Type>();
        if (this.throwsArithmeticException()) {
            l.add(ts.ArithmeticException());
        }
        return l;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Assign(this.position, this.left, this.op, this.right);
    }
}

