/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.ArrayAccess;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class ArrayAccess_c
extends Expr_c
implements ArrayAccess {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr array;
    protected Expr index;

    public ArrayAccess_c(Position pos, Expr array, Expr index) {
        this(pos, array, index, null);
    }

    public ArrayAccess_c(Position pos, Expr array, Expr index, Ext ext) {
        super(pos, ext);
        assert (array != null && index != null);
        this.array = array;
        this.index = index;
    }

    @Override
    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public Expr array() {
        return this.array;
    }

    @Override
    public ArrayAccess array(Expr array) {
        return this.array(this, array);
    }

    protected <N extends ArrayAccess_c> N array(N n, Expr array) {
        if (n.array == array) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.array = array;
        return n;
    }

    @Override
    public Expr index() {
        return this.index;
    }

    @Override
    public ArrayAccess index(Expr index) {
        return this.index(this, index);
    }

    protected <N extends ArrayAccess_c> N index(N n, Expr index) {
        if (n.index == index) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.index = index;
        return n;
    }

    @Override
    public Flags flags() {
        return Flags.NONE;
    }

    protected <N extends ArrayAccess_c> N reconstruct(N n, Expr array, Expr index) {
        n = this.array(n, array);
        n = this.index(n, index);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr array = this.visitChild(this.array, v);
        Expr index = this.visitChild(this.index, v);
        return this.reconstruct(this, array, index);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!this.array.type().isArray()) {
            throw new SemanticException("Subscript can only follow an array type.", this.position());
        }
        if (!ts.isImplicitCastValid(this.index.type(), ts.Int())) {
            throw new SemanticException("Array subscript must be an integer.", this.position());
        }
        return this.type(this.array.type().toArray().base());
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.index) {
            return ts.Int();
        }
        if (child == this.array) {
            return ts.arrayOf(this.type);
        }
        return child.type();
    }

    @Override
    public String toString() {
        return this.array + "[" + this.index + "]";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printSubExpr(this.array, w, tr);
        w.write("[");
        this.printBlock(this.index, w, tr);
        w.write("]");
    }

    @Override
    public Term firstChild() {
        return this.array;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFG(this.array, this.index, 1);
        v.visitCFG(this.index, this, 0);
        return succs;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        return CollectionUtil.list(ts.OutOfBoundsException(), ts.NullPointerException());
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.ArrayAccess(this.position, this.array, this.index);
    }
}

