/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.AmbExpr;
import polyglot.ast.Ambiguous;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class AmbExpr_c
extends Expr_c
implements AmbExpr {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Id name;

    public AmbExpr_c(Position pos, Id name) {
        this(pos, name, null);
    }

    public AmbExpr_c(Position pos, Id name, Ext ext) {
        super(pos, ext);
        assert (name != null);
        this.name = name;
    }

    @Override
    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public Id id() {
        return this.name;
    }

    @Override
    public AmbExpr id(Id id) {
        return this.id(this, id);
    }

    protected <N extends AmbExpr_c> N id(N n, Id name) {
        if (n.name == name) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.name = name;
        return n;
    }

    @Override
    public String name() {
        return this.name.id();
    }

    @Override
    public AmbExpr name(String name) {
        return this.id(this.name.id(name));
    }

    protected <N extends AmbExpr_c> N reconstruct(N n, Id name) {
        n = this.id(n, name);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Id name = this.visitChild(this.name, v);
        return this.reconstruct(this, name);
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        Node n = ar.nodeFactory().disamb().disambiguate((Ambiguous)this, (ContextVisitor)ar, this.position(), null, this.name);
        if (n instanceof Expr) {
            return n;
        }
        throw new SemanticException("Could not find field or local variable \"" + this.name + "\".", this.position());
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        return this;
    }

    @Override
    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        throw new InternalCompilerError(this.position(), "Cannot exception check ambiguous node " + this + ".");
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        tr.print(this, this.name, w);
    }

    @Override
    public String toString() {
        return this.name.toString() + "{amb}";
    }

    @Override
    public Term firstChild() {
        return null;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.AmbExpr(this.position, this.name);
    }
}

