/*
 * Decompiled with CFR 0.152.
 */
package iContract.doclet;

import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.ClassTree;
import com.sun.tools.doclets.DocletAbortException;
import iContract.doclet.AbstractTreeWriter;
import iContract.doclet.ConfigurationStandard;
import iContract.doclet.Standard;
import java.io.IOException;
import java.io.PrintWriter;

public class TreeWriter
extends AbstractTreeWriter {
    private PackageDoc[] packages;
    private boolean classesonly;

    public TreeWriter(String string, ClassTree classTree) throws IOException, DocletAbortException {
        super(string, classTree);
        this.packages = Standard.configuration().packages;
        this.classesonly = this.packages.length == 0;
    }

    public static void generate(ClassTree classTree) throws DocletAbortException {
        String string = "overview-tree.html";
        try {
            TreeWriter treeWriter = new TreeWriter(string, classTree);
            treeWriter.generateTreeFile();
            ((PrintWriter)((Object)treeWriter)).close();
        }
        catch (IOException iOException) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    public void generateTreeFile() throws IOException {
        this.printHeader(this.getText("doclet.Window_Class_Hierarchy", Standard.configuration().windowtitle));
        this.printTreeHeader();
        this.printPageHeading();
        this.printPackageTreeLinks();
        this.generateTree(this.classtree.baseclasses(), "doclet.Class_Hierarchy");
        this.generateTree(this.classtree.baseinterfaces(), "doclet.Interface_Hierarchy");
        this.printTreeFooter();
    }

    protected void printPackageTreeLinks() {
        if (!this.classesonly) {
            this.dl();
            this.dt();
            this.boldText("doclet.Package_Hierarchies");
            this.dd();
            int n = 0;
            while (n < this.packages.length) {
                String string = this.pathString(this.packages[n], "package-tree.html");
                this.printHyperLink(string, "", this.packages[n].name());
                if (n < this.packages.length - 1) {
                    ((PrintWriter)((Object)this)).print(", ");
                }
                ++n;
            }
            this.dlEnd();
            this.hr();
        }
    }

    protected void printTreeHeader() {
        this.navLinks(true);
        this.hr();
    }

    protected void printTreeFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printPageHeading() {
        this.center();
        this.h2();
        this.printText("doclet.Hierarchy_For_All_Packages");
        this.h2End();
        this.centerEnd();
    }
}

