/*
 * Decompiled with CFR 0.152.
 */
package ppg.util;

import java.io.IOException;
import java.io.Writer;
import ppg.util.Item;
import ppg.util.Overrun;

class AllowBreak
extends Item {
    int indent;
    boolean broken = true;
    String alt;

    AllowBreak(int n_, String alt_) {
        this.indent = n_;
        this.alt = alt_;
    }

    @Override
    int formatN(int lmargin, int pos, int rmargin, int fin, boolean can_break, boolean nofail) throws Overrun {
        if (can_break) {
            pos = lmargin + this.indent;
            this.broken = true;
        } else {
            pos += this.alt.length();
            this.broken = false;
        }
        return AllowBreak.format(this.next, lmargin, pos, rmargin, fin, can_break, nofail);
    }

    @Override
    int sendOutput(Writer o, int lmargin, int pos) throws IOException {
        if (this.broken) {
            o.write("\r\n");
            for (int i = 0; i < lmargin + this.indent; ++i) {
                o.write(" ");
            }
            return lmargin + this.indent;
        }
        o.write(this.alt);
        return pos + this.alt.length();
    }
}

