/*
 * Decompiled with CFR 0.152.
 */
package jflex;

public final class Interval {
    public char start;
    public char end;

    public Interval(char start, char end) {
        this.start = start;
        this.end = end;
    }

    public Interval(Interval other) {
        this.start = other.start;
        this.end = other.end;
    }

    public boolean contains(char point) {
        return this.start <= point && this.end >= point;
    }

    public boolean contains(Interval other) {
        return this.start <= other.start && this.end >= other.end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)o;
        return other.start == this.start && other.end == this.end;
    }

    public void setEnd(char end) {
        this.end = end;
    }

    public void setStart(char start) {
        this.start = start;
    }

    private static boolean isPrintable(char c) {
        return c > '\u001f' && c < '\u007f';
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        if (Interval.isPrintable(this.start)) {
            result.append("'").append(this.start).append("'");
        } else {
            result.append((int)this.start);
        }
        if (this.start != this.end) {
            result.append("-");
            if (Interval.isPrintable(this.end)) {
                result.append("'").append(this.end).append("'");
            } else {
                result.append((int)this.end);
            }
        }
        result.append("]");
        return result.toString();
    }

    public Interval copy() {
        return new Interval(this.start, this.end);
    }
}

