/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.util.ArrayList;
import java.util.List;
import jflex.Interval;
import jflex.unicode.UnicodeProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntCharSet {
    private static final boolean DEBUG = false;
    private List<Interval> intervals;
    private int pos;

    public IntCharSet() {
        this.intervals = new ArrayList<Interval>();
    }

    public IntCharSet(char c) {
        this(new Interval(c, c));
    }

    public IntCharSet(Interval interval) {
        this();
        this.intervals.add(interval);
    }

    public IntCharSet(List<Interval> chars) {
        int size = chars.size();
        this.intervals = new ArrayList<Interval>(size);
        for (Interval interval : chars) {
            this.add(interval);
        }
    }

    private int indexOf(char c) {
        int start = 0;
        int end = this.intervals.size() - 1;
        while (start <= end) {
            int check = (start + end) / 2;
            Interval i = this.intervals.get(check);
            if (start == end) {
                return i.contains(c) ? start : -1;
            }
            if (c < i.start) {
                end = check - 1;
                continue;
            }
            if (c > i.end) {
                start = check + 1;
                continue;
            }
            return check;
        }
        return -1;
    }

    public IntCharSet add(IntCharSet set) {
        for (Interval interval : set.intervals) {
            this.add(interval);
        }
        return this;
    }

    public void add(Interval interval) {
        int size = this.intervals.size();
        for (int i = 0; i < size; ++i) {
            Interval elem = this.intervals.get(i);
            if (elem.end + '\u0001' < interval.start) continue;
            if (elem.contains(interval)) {
                return;
            }
            if (elem.start > interval.end + '\u0001') {
                this.intervals.add(i, new Interval(interval));
                return;
            }
            if (interval.start < elem.start) {
                elem.start = interval.start;
            }
            if (interval.end <= elem.end) {
                return;
            }
            elem.end = interval.end;
            ++i;
            while (i < size) {
                Interval x = this.intervals.get(i);
                if (x.start > elem.end + '\u0001') {
                    return;
                }
                if (x.end > elem.end) {
                    elem.end = x.end;
                }
                this.intervals.remove(i);
                --size;
            }
            return;
        }
        this.intervals.add(new Interval(interval));
    }

    public void add(char c) {
        int size = this.intervals.size();
        for (int i = 0; i < size; ++i) {
            Interval elem = this.intervals.get(i);
            if (elem.end + '\u0001' < c) continue;
            if (elem.contains(c)) {
                return;
            }
            if (elem.start > c + '\u0001') {
                this.intervals.add(i, new Interval(c, c));
                return;
            }
            if (c + '\u0001' == elem.start) {
                elem.start = c;
                return;
            }
            elem.end = c;
            if (i + 1 >= size) {
                return;
            }
            Interval x = this.intervals.get(i + 1);
            if (x.start <= c + '\u0001') {
                elem.end = x.end;
                this.intervals.remove(i + 1);
            }
            return;
        }
        this.intervals.add(new Interval(c, c));
    }

    public boolean contains(char singleChar) {
        return this.indexOf(singleChar) >= 0;
    }

    public boolean equals(Object o) {
        IntCharSet set = (IntCharSet)o;
        return ((Object)this.intervals).equals(set.intervals);
    }

    private char min(char a, char b) {
        return a <= b ? a : b;
    }

    private char max(char a, char b) {
        return a >= b ? a : b;
    }

    public IntCharSet and(IntCharSet set) {
        IntCharSet result = new IntCharSet();
        int i = 0;
        int j = 0;
        int size = this.intervals.size();
        int setSize = set.intervals.size();
        while (i < size && j < setSize) {
            Interval x = this.intervals.get(i);
            Interval y = set.intervals.get(j);
            if (x.end < y.start) {
                ++i;
                continue;
            }
            if (y.end < x.start) {
                ++j;
                continue;
            }
            result.intervals.add(new Interval(this.max(x.start, y.start), this.min(x.end, y.end)));
            if (x.end >= y.end) {
                ++j;
            }
            if (y.end < x.end) continue;
            ++i;
        }
        return result;
    }

    public void sub(IntCharSet set) {
        int i = 0;
        int j = 0;
        int setSize = set.intervals.size();
        while (i < this.intervals.size() && j < setSize) {
            Interval x = this.intervals.get(i);
            Interval y = set.intervals.get(j);
            if (x.end < y.start) {
                ++i;
                continue;
            }
            if (y.end < x.start) {
                ++j;
                continue;
            }
            if (x.start == y.start && x.end == y.end) {
                this.intervals.remove(i);
                ++j;
                continue;
            }
            if (x.start == y.start) {
                x.start = (char)(y.end + '\u0001');
                ++j;
                continue;
            }
            if (x.end == y.end) {
                x.end = (char)(y.start - '\u0001');
                ++i;
                ++j;
                continue;
            }
            this.intervals.add(i, new Interval(x.start, (char)(y.start - '\u0001')));
            x.start = (char)(y.end + '\u0001');
            ++i;
            ++j;
        }
    }

    public boolean containsElements() {
        return this.intervals.size() > 0;
    }

    public int numIntervals() {
        return this.intervals.size();
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public Interval getNext() {
        if (this.pos == this.intervals.size()) {
            this.pos = 0;
        }
        return this.intervals.get(this.pos++);
    }

    public IntCharSet getCaseless(UnicodeProperties unicodeProperties) {
        IntCharSet n = this.copy();
        int size = this.intervals.size();
        for (int i = 0; i < size; ++i) {
            Interval elem = this.intervals.get(i);
            for (char c = elem.start; c <= elem.end; c = (char)(c + '\u0001')) {
                IntCharSet equivalenceClass = unicodeProperties.getCaselessMatches(c);
                if (null == equivalenceClass) continue;
                n.add(equivalenceClass);
            }
        }
        return n;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{ ");
        for (Interval interval : this.intervals) {
            result.append(interval);
        }
        result.append(" }");
        return result.toString();
    }

    public IntCharSet copy() {
        IntCharSet result = new IntCharSet();
        for (Interval interval : this.intervals) {
            result.intervals.add(interval.copy());
        }
        return result;
    }
}

