function [ img_kappa, img_avg, img2_avg ] = pao_compute_kappa_imgs(img_fnames, gamma, shift)

if ~exist('gamma', 'var')
    gamma = 1;
end

img = pao_imread(img_fnames{1});

img_avg = zeros(size(img));
img2_avg = zeros(size(img));
count = zeros(size(img,1), size(img,2));

for i = 1:length(img_fnames)
    img = pao_imread(img_fnames{i}).^gamma;
        
    if false
        % mask fname
        [p, n, e] = fileparts(img_fnames{i});
        mask_fname = fullfile(p, [n '.png']);
        mask = imread(mask_fname);
        count(mask ~= 0) = count(mask ~= 0) + 1;
    end
    
    if exist('shift','var')
        subplot(1,4,1); imshow(img)        
        subplot(1,4,2); imshow(abs(shift - img))
        subplot(1,4,3); imshow(max(0, img - shift))
        subplot(1,4,4); imshow(max(0, shift - img))
        pause

        
        img = max(0, img - shift);
      
        %[min(img(:)) max(img(:))]

    end
    
    img_avg = img_avg + img;
    img2_avg = img2_avg + img.^2;
end

if true
    img_avg = img_avg / length(img_fnames);
    img2_avg = img2_avg / length(img_fnames);
else
    count = max(count, 1);
    img_avg = img_avg ./ repmat(count, [1 1 3]);
    img2_avg = img2_avg ./ repmat(count, [1 1 3]);
end

img_kappa = img_avg.^2 ./ max(realmin('double'), img2_avg);

end