function [ albedo ] = pao_compute_albedo(avg_img, alpha, f)

albedo = zeros(size(avg_img));

if numel(f) == size(avg_img,3)
    new_f = zeros(size(avg_img));
    for i = 1:numel(f)
        new_f(:,:,i) = f(i);
    end
    f = new_f;
end

for i = 1:size(f,3)
    albedo(:,:,i) = 2 * avg_img(:,:,i) ./ ((1 + 2 * f(:,:,i) * pi) .* sin(alpha).^2);
end

end