function [ depth_map, sky_prob, is_valid] = semantic_filtering( root,oringal_image, depth_map, depth_map_pho, folder_, image_name,S_name,manhattan_model_number_)
%SEMANTIC_FILTERING Summary of this function goes here
%   Detailed explanation goes here

%% use semantic segmentation for filter 
subgroup_name1 = '/map/label_map';
subgroup_name2 = '/map/prob_map';

is_valid = 1;

segmentation_filename = strcat(root,'/phoenix/',S_name,'/zl548/semantic_map/',folder_,'/images/',image_name,'.h5' ); 
CRF_label = hdf5read(segmentation_filename,subgroup_name1);
prob_prob = hdf5read(segmentation_filename,subgroup_name2);

CRF_label = imresize(CRF_label,size(depth_map),'nearest');
prob_prob = imresize(prob_prob,size(depth_map),'bilinear');

img = oringal_image;
% human_prob = hdf5read(segmentation_filename,subgroup_name3);
% CRF_label = imresize(CRF_label,size(depth_map),'nearest');
% prob_prob = imresize(prob_prob,size(depth_map));
% img = imresize(oringal_image,size(CRF_label));
% depth_map = imresize(depth_map,size(CRF_label),'nearest');
% depth_map_old = depth_map;
% depth_map_pho = imresize(depth_map_pho,size(CRF_label),'nearest');

sky_prob = prob_prob(:,:,1);
max_sky_prob = max(max(sky_prob));
sky_mask = (CRF_label == 3) | (sky_prob > 0.25);

% depth_maprgb= convert_depth2RGB(depth_map);
% figure;imshow(depth_maprgb,[]); figure;imshow(img,[])
if max_sky_prob > 0.5 
%     idx = max_sky_prob_idx(0);
    oringal_image_gray = rgb2gray(img);
    sky_pixels = oringal_image_gray(find(sky_mask == 1));
    sky_L_median = median(sky_pixels);

    % images are too dark
    if sky_L_median < 100 
       is_valid = 0;
       return;
    end
   
end

num_valid = size(find(sky_mask==0),1);
num_valid_depth = size(find(depth_map > 0),1);

ratio = num_valid_depth/num_valid;
if ratio < 0.35
    is_valid = 0;
    return;
end

depth_ratio = depth_map./depth_map_pho;

member_array = [2,11,0,7,12,20,21,24,27,32,33,34,35,36,37,41,43,44,46,47,48,49,50, 57, 60,61,63,64,65,...
    71, 76, 78, 80,83,86, 94, 95, 98, 100, 101, 102,103,104,105,107,115,117,130,133,141,143,147,148,150,160, 162, 168, 175, 178, 183,...
    186, 189, 197,200,212,235,257,269,271,277,285, 303, 307,331, 341,349,366, 377, 380, 387, 389,402, 406, 430 ...
    , 478,482, 493, 494, 496, 505, 559, 733, 768, 860, 1001, 1017, 1589, 3346, 4541, 105, 121, 176, 177, 181, 190, 209, ...
    214, 223, 224, 231, 237, 240,243,252, 258, 265, 275, 281, 294,299,312,323, 326, 327, 348, 360, 394, 407, 411, 412, 443, 476, 496, 472];

%% in the last iteration of COLMAP, we choose more reliable depth from two depths maps.
if ismember(str2num(folder_), member_array) 
    disp('images of sky-line!!!');
    %% median filter
    depth_ratio = max(1./depth_ratio,depth_ratio);
    idx = find(depth_ratio > 1.15);
    %% assign closer pixels
    depth_map(idx) = nan;
    depth_map_new= nanmedfilt2(depth_map,7);
    %% filter out unstable pixels
    ratio = depth_map_new./depth_map;
    ratio = max(1./ratio,ratio);
    depth_map(find(ratio > 1.15)) = nan;    
else
    idx = find(depth_ratio > 1.1);
    %% assign closer pixels
    depth_map(idx) = depth_map_pho(idx);
    %% median filter
    depth_map_new= nanmedfilt2(depth_map,7);
    depth_map_new= nanmedfilt2(depth_map_new,7);
    %% filter out unstable pixels
    ratio = depth_map_new./depth_map;
    ratio = max(1./ratio,ratio);
    depth_map_new(find(ratio > 1.1)) = nan;
    depth_map = depth_map_new;
end

%% semantic filtering begin
trees_map =  prob_prob(:,:,2);
trees_mask = (CRF_label == 5) | (trees_map > 0.25);
human_map =  prob_prob(:,:,3);

if str2num(folder_) == 168 || str2num(folder_) == 212
    creature_mask = zeros(size(CRF_label));
else
    creature_mask = (CRF_label==13) | (CRF_label==127) | (human_map > 0.25);
end
% fountain_map =  prob_prob(:,:,4);
fountain_mask = (CRF_label == 105);
% sculpture_map =  prob_prob(:,:,5);
sculpture_mask = (CRF_label == 133);
% forgounrd_prob_map = prob_prob(:,:,6);
forgounrd_mask = (CRF_label == 37) |(CRF_label == 135)|(CRF_label == 137) |...
    (CRF_label == 88)|(CRF_label == 101)|(CRF_label == 145)|(CRF_label == 150)|...
    (CRF_label == 44)|(CRF_label == 94)|(CRF_label == 9) | (CRF_label == 116);
% car_prob_map = prob_prob(:,:,7);
transportation_mask = (CRF_label == 21) |(CRF_label == 81)|(CRF_label == 103) |...
    (CRF_label == 84)|(CRF_label == 77)|(CRF_label == 104);
water_mask = (CRF_label == 22) |(CRF_label == 27) |(CRF_label == 61)|(CRF_label == 129);
%% possible reconstruction 
% (1) people and sculpture, find connected components in the binary image
% (2) fountain_mask
% (3) trees_mask
% (4) column !
depth_map = check_semantics(trees_mask,depth_map);
plant_mask = (CRF_label == 18);
depth_map = check_semantics(plant_mask,depth_map);
depth_map = check_semantics(creature_mask,depth_map);
depth_map = check_semantics(fountain_mask,depth_map);
depth_map = check_semantics(sculpture_mask,depth_map);

%% impossible reconstruction in Internet photos
if str2num(folder_) == 229
    occulusion_mask = zeros(size(depth_map));
else
    occulusion_mask = transportation_mask|sky_mask | forgounrd_mask |water_mask;
end

%% 
se = strel('disk',4);
final_semantic_mask = imdilate(occulusion_mask,se);
% final_semantic_mask =  occulusion_mask;

%% apply morphologial erosion in the end
depth_map_mask = depth_map > 0;
se = strel('disk',2);
depth_map_mask = imclose(depth_map_mask,se);
se = strel('disk',4);
depth_map_mask = imerode(depth_map_mask,se);
depth_map_mask = bwareaopen(depth_map_mask, 200);
depth_map(depth_map_mask<1) = nan;
depth_map(final_semantic_mask>0) = nan;

num_valid = size(find(sky_mask==0),1);
num_valid_depth = size(find(depth_map > 0),1);

% 
% depth_map_new = convert_depth2RGB(depth_map);
% depth_map_old = convert_depth2RGB(depth_map_old);
% figure;imshow(img,[]); title('img');
% figure;imshow(depth_map_new,[]); title('new');
% figure;imshow(depth_map_old,[]);title('old');
% 
% close all;

ratio_v = 0.35;
if str2num(folder_) == 168 || str2num(folder_) == 229 || str2num(folder_) == 212 || str2num(folder_) == 768 
    ratio_v = 0.2;
end

ratio_post = num_valid_depth/num_valid;
if ratio_post < ratio_v
    is_valid = 0;
    return;
end

%% end


end

