function [  ] = processDataCluster(root, folder_num, folder_, manhattan_model_number,working_path, base_path, S_name)
%PROCESSDATA Summary of this function goes here
%   Detailed explanation goes here
% addpath('./visualizationCode/')
% load color150.mat

%% scenes with all images of skyline or panorama
sky_line_group = [0, 2, 11,21,43, 46,50 ,87, 92, 95, 100, 103, 105, 122, 133 , 143, 147, 105, 168, 177 ...
    , 178, 214,223, 237, 252, 265, 275,341, 406, 860, 58, 183, 212, 257, 269, 349, 430, 768];

%% option
% visualization = false;
% write_to_disk = false;
% write_to_hdf5 = false;
% write_ord_img = false;
% write_to_hdf5_ORD = false;


%% read bundler main files
bundle_f_id1 = fopen(strcat(working_path, '/bundler.bundle.out'),'r');
bundle_file = textscan(bundle_f_id1,'%s','HeaderLines',1,'Delimiter','\n');
%% read image list bundler format
bundle_f_id2 = fopen(strcat(working_path, '/bundler.list.txt'),'r');
bundle_image_file = textscan(bundle_f_id2,'%s','Delimiter','\n');

info = strsplit(char(bundle_file{1}(1)));
num_cameras = str2num(info{1});
num_points = str2num(info{2});

manhattan_model_number_ = str2num(manhattan_model_number);

mkdir(strcat(root,'/phoenix/S6/zl548/MegaDepth_v1/',folder_,'/','/dense',manhattan_model_number,'/imgs/'));
mkdir(strcat(root,'/phoenix/S6/zl548/MegaDepth_v1/',folder_,'/','/dense',manhattan_model_number,'/depths/'));

%% change to parfor if needed 
%% for each image 
for i = 3:num_cameras
        i
        %% read bundler image file
        image_name = char(bundle_image_file{1}(i));
        
        %% check if photos are rotated 
        if compute_image_orientation(bundle_file, i) == 1
            continue;
        end
        
         %% read input raw depth 
        if manhattan_model_number_ == 0
            input_path_pho = strcat(base_path,folder_,'/dense/','//stereo/depth_maps/', image_name, '.photometric.bin');
            input_path_geo = strcat(base_path,folder_,'/dense/','//stereo/depth_maps/', image_name, '.geometric.bin');
            img_name = strcat(root,'/phoenix/',S_name,'/zl548/colmap_image_final2/',folder_,'/','/dense','/images/', image_name);    

        else
            input_path_pho = strcat(base_path,folder_,'/dense',manhattan_model_number,'/stereo/depth_maps/', image_name,'.photometric.bin') ;
            input_path_geo = strcat(base_path,folder_,'/dense',manhattan_model_number,'/stereo/depth_maps/', image_name, '.geometric.bin');
            img_name = strcat(root,'/phoenix/',S_name,'/zl548/colmap_image_final2/',folder_,'/','/dense',manhattan_model_number,'/images/', image_name);    

        end
        

        %% if dense depth map does not exists === > the image is bad ===> skip
        if ~ exist(input_path_pho, 'file') && ~ exist(input_path_geo, 'file')
            disp('bad image, skip!!')
            continue
        end
        
        if  ~ exist(input_path_geo, 'file')
            disp('bad image, skip!!')
            continue
        end
        
        disp(img_name);
        oringal_image = imread(img_name);
        
        % check size of image and check if is broken or invalid formats
        if check_size_broken(oringal_image) == 1
            continue;
        end   
        
        %% skip one strange image that crashes the program......
        if strcmp(img_name ,'/phoenix/S6/zl548/MegaDepth_v1/0044//dense0/images/5368083511_619a3faec2_b.jpg')
           continue; 
        end

        [depth_map_geo, depth_map_rgb_geo] = read_depth_map(input_path_geo);

        if ~ exist(input_path_pho, 'file') 
            disp('weakly reconstruction scenes or very dark scenes where all algorithms will fail!'); 
            if ismember(str2num(folder_), sky_line_group)
                continue;
            end

            [final_map , sky_prob_map, is_valid_ordinal] = generate_ordinal_labels(root, oringal_image, depth_map_geo, folder_, image_name,S_name);

            if is_valid_ordinal == 0
                continue; 
            end
            
            png_folder_path = strcat(root,'/phoenix/S6/zl548/MegaDepth_v1/',folder_,'/','/dense',manhattan_model_number,'/depths/');
            hdf5_write_path = strcat(png_folder_path, image_name(1:end-4), '.h5');

            if ~exist(hdf5_write_path, 'file')
                    h5create(hdf5_write_path,'/depth',size(final_map'),'Datatype','single','ChunkSize',[64 64],'Deflate',9);
                    h5write(hdf5_write_path,'/depth', single(final_map')); 
            end
            
            %% write image
            r_img_name = strcat(root,'/phoenix/S6/zl548/MegaDepth_v1/',folder_,'/','/dense',manhattan_model_number,'/imgs/', image_name);    
            imwrite(oringal_image, r_img_name);
            
            continue
        end
        
        
        [depth_map_pho, depth_map_rgb_pho] = read_depth_map(input_path_pho);
        [depth_map_masked, sky_prob_map, is_valid]= semantic_filtering(root,oringal_image, depth_map_geo, depth_map_pho, folder_, image_name,S_name,manhattan_model_number_);            

        
        %% generate semantics auto ordinal labels 
        if  is_valid < 0.5
            disp('weakly reconstruction scenes!'); 
            if ismember(str2num(folder_), sky_line_group)
                continue;
            end
            
            [final_map , sky_prob_map, is_validnew] = generate_ordinal_labels(root, oringal_image, depth_map_geo, folder_, image_name,S_name);

            if is_validnew == 0
                continue; 
            end
            
            png_folder_path = strcat(root,'/phoenix/S6/zl548/MegaDepth_v1/',folder_,'/','/dense',manhattan_model_number,'/depths/');
            hdf5_write_path = strcat(png_folder_path, image_name(1:end-4), '.h5');

            if ~exist(hdf5_write_path, 'file')
                    h5create(hdf5_write_path,'/depth',size(final_map'),'Datatype','single','ChunkSize',[64 64],'Deflate',9);
                    h5write(hdf5_write_path,'/depth', single(final_map')); 
            end

            r_img_name = strcat(root,'/phoenix/S6/zl548/MegaDepth_v1/',folder_,'/','/dense',manhattan_model_number,'/imgs/', image_name);    
            imwrite(oringal_image, r_img_name);
            
            continue

        end
        
        %% if images is valid, we need save dense depth map from COLMAP 
        png_folder_path = strcat(root,'/phoenix/S6/zl548/MegaDepth_v1/',folder_,'/','/dense',manhattan_model_number,'/depths/');    
        mkdir(png_folder_path);
        hdf5_write_path = strcat(png_folder_path, image_name(1:end-4), '.h5');
        depth_map_masked(isnan(depth_map_masked)) = 0.0;
        
        if ~exist(hdf5_write_path, 'file')
                h5create(hdf5_write_path,'/depth',size(depth_map_masked'),'Datatype','single','ChunkSize',[64 64],'Deflate',9);
                h5write(hdf5_write_path,'/depth', single(depth_map_masked')); 
        end
        
        r_img_name = strcat(root,'/phoenix/S6/zl548/MegaDepth_v1/',folder_,'/','/dense',manhattan_model_number,'/imgs/', image_name);    
        imwrite(oringal_image, r_img_name);

    
end

