function [ final_map , sky_prob, is_valid] = generate_ordinal_labels( root, oringal_image, depth_map, folder_, image_name,S_name )
%GENERATE_ORDINAL_LABELS Summary of this function goes here
%   Detailed explanation goes here
%% use semantic segmentation for filter 
subgroup_name1 = '/map/label_map';
subgroup_name2 = '/map/prob_map';

is_valid = 0;

segmentation_filename = strcat(root,'/phoenix/',S_name,'/zl548/semantic_map/',folder_,'/images/',image_name,'.h5' ); 
CRF_label = hdf5read(segmentation_filename,subgroup_name1);
prob_prob = hdf5read(segmentation_filename,subgroup_name2);

% img = imresize(oringal_image,size(CRF_label));
depth_map = imresize(depth_map,size(CRF_label),'nearest');

%% we force the depth of sky to be close to 0 
sky_prob = prob_prob(:,:,1);
max_sky_prob = max(max(sky_prob));
sky_mask = (CRF_label == 3) | (sky_prob > 0.25);
img = imresize(oringal_image, size(sky_mask));
final_map = zeros(size(depth_map));
% depth_maprgb= convert_depth2RGB(depth_map);
% figure;imshow(depth_maprgb,[]); figure;imshow(img,[])
if max_sky_prob > 0.5 
%     idx = max_sky_prob_idx(0);
    oringal_image_gray = rgb2gray(img);
    sky_pixels = oringal_image_gray(find(sky_mask == 1));
    sky_L_median = median(sky_pixels);
%     sky_L_median
    if sky_L_median < 100 
       is_valid = 0;
       return;
    end
   
end

%% forgound objects 
%% case 1: forground objects are connected to bottom of the image, 
%% and it must be in front of everything 
trees_mask = (CRF_label == 5) | (CRF_label == 18);
% final_map = find_cc_large(final_map, trees_mask,1);
human_mask = (CRF_label==13);
final_map =find_cc_large(final_map, human_mask,2);
animals_mask = (CRF_label==127);
final_map = find_cc_large(final_map, animals_mask,3);
sculpture_mask = (CRF_label == 133);
final_map = find_cc_large(final_map, sculpture_mask,4);
transportation_mask = (CRF_label == 21) |(CRF_label == 81)|(CRF_label == 103) |...
    (CRF_label == 84)|(CRF_label == 77)|(CRF_label == 104) | (CRF_label == 128);
final_map = find_cc_large(final_map, transportation_mask,5);
forgounrd_mask = (CRF_label == 37) |(CRF_label == 135)|(CRF_label == 137) |...
    (CRF_label == 88)|(CRF_label == 101)|(CRF_label == 145)|(CRF_label == 20)|...
    (CRF_label == 44)|(CRF_label == 94)|(CRF_label == 9) | (CRF_label == 31) | (CRF_label == 116);
final_map = find_cc_large(final_map, forgounrd_mask,6);
fountain_mask = (CRF_label == 105);
final_map = find_cc_large(final_map, forgounrd_mask,7);

occulusion_mask = forgounrd_mask | transportation_mask | sculpture_mask | animals_mask | human_mask | trees_mask | fountain_mask;

background_mask = (CRF_label == 85) | (CRF_label == 1) | (CRF_label == 2) | (CRF_label == 26) |...
    (CRF_label == 49) | (CRF_label == 62) | (CRF_label == 43) |(CRF_label == 17);
depth_map_mask = depth_map > 0;
final_map(depth_map > 0) = 0;
se = strel('disk',4);
depth_map_mask = imerode(depth_map_mask,se);
depth_map_mask = bwareaopen(depth_map_mask, 1000);

depth_map  = depth_map.*depth_map_mask;

d_vd_vecec = depth_map(find(~isnan(depth_map)));
per_mask = depth_map> prctile(d_vd_vecec, 75);
per_mask(round(size(depth_map_mask,1)*4/5):end,:) = 0;

final_map( per_mask == 1 & occulusion_mask == 0 & background_mask == 1) = -1;


%% find background mask 
background_mask = (final_map == -1);
cc = bwconncomp(background_mask);
min_region = 3000;
for p = 1:cc.NumObjects
    linear_idx = cc.PixelIdxList{p};
    [i,j] = ind2sub(size(background_mask),linear_idx);
    
    if size(linear_idx,1) < min_region || min(i) > (size(forgounrd_mask,1)/2)
        final_map(linear_idx) = 0;
    end
end


% ground_mask = (CRF_label == 22) | (CRF_label == 61)|...
%     (CRF_label == 129) | (CRF_label == 4) | (CRF_label == 7) | (CRF_label == 12) | (CRF_label == 30);

% final_map( ground_mask == 1 & isnan(depth_map) ) = -1;


f_mask = (final_map ~= 0);
f_mask = bwareaopen(f_mask, 1000);
final_map = final_map .* f_mask;

min_region = 3000;

if max(max(final_map)) > 0 && min(min(final_map)) < 0 && size(find(final_map < 0),1) > min_region
    is_valid = 1;
end



end

