function orientation = compute_image_orientation( bundle_file, i )
%COMPUTE_IMAGE_ORIENTATION Summary of this function goes here
%   check if images are orientated 
        orientation = 0;
        line_number = 5*i - 3;
        focal_length = str2num(char(bundle_file{1}(line_number)));
        R_1 = str2num(char(bundle_file{1}(line_number+1))); 
        R_2 = str2num(char(bundle_file{1}(line_number+2)));
        R_3 = str2num(char(bundle_file{1}(line_number+3)));
        R_C_G = [R_1;R_2;R_3];
        T_C_G = str2num(char(bundle_file{1}(line_number+4)));
        
        T_G_C = R_C_G'*T_C_G';
        
        x_axis = R_1;
        y_axis = R_2;
        
        up_vector = [0 -1 0];
        
        vector_angle_X = acosd(dot(x_axis,up_vector)/(norm(x_axis)*norm(up_vector)));
        vector_angle_Y = acosd(dot(y_axis,up_vector)/(norm(y_axis)*norm(up_vector)));

        if abs(vector_angle_X) < 60 || abs(vector_angle_X - 180) < 60 || abs(vector_angle_Y) > 75
            disp('rotated cameras!!!!!!!!!!!!!!!!!!!!');
            orientation = 1;
        end

        
end

