#include <stdio.h>
#include <stdlib.h>

#define MATXSIZE 300
typedef double** matx_t;

// a = mn
void matxmult(matx_t a, matx_t m, matx_t n) {
  int i,j,k;
  for(i = 0; i < MATXSIZE; i++) {
    for(j = 0; j < MATXSIZE; j++) {
      for(k = 0; k < MATXSIZE; k++) {
	a[i][j] += m[i][k] * n[k][j];
      }
    }
  }
}

void mkmatx(matx_t x) {
  int i,j;
  for(i = 0; i < MATXSIZE; i++) {
    for(j = 0; j < MATXSIZE; j++) {
      x[i][j] = rand();
    }
  }
}

matx_t initmatx() {
  int i,j;
  matx_t ptr = (matx_t)malloc(sizeof(double*)*MATXSIZE);
  for(i = 0; i < MATXSIZE; i++) {
    ptr[i] = (double*)malloc(sizeof(double)*MATXSIZE);
    for(j = 0; j < MATXSIZE; j++) {
      ptr[i][j] = (double)0.0;
    }
  }
  return ptr;
}

int main(int argc, char** argv) {
  int i;
  matx_t x, y, a;
  x = initmatx();
  y = initmatx();
  a = initmatx();

  if(argc < 2)  {
    fprintf(stderr, "usage: matxmult seed\n");
    return 0;
  }
  printf("Seed %d\n", atoi(argv[1]));
  srand(atoi(argv[1]));
  mkmatx(x);
  mkmatx(y);
  matxmult(a,x,y);
  return 0;
}
