%{
#include "cmump.h"
#include "multpol.h"
#include <core.h>

#define NBUF 1000

extern MPOL tempmon,temp;
extern MINT coef;
extern short expo[1000];
extern int status;
extern char ?numbers[NBUF];

extern void initall(void);
extern void clean_num(void);
extern void clean1(void);

%}
%union {
  Int(int);
}
%token NUMBER,SYMBOL,POWER,PLUS,MINUS,STOP,TIMES,SEP,UNKNOWN,FULBUF
%type <int> NUMBER, SYMBOL
%%

read	:	pol STOP	{return 0;}
		|	STOP  		{status=1;return 0;}
		|	error		{status=2;return 0;}
		|	FULBUF		{status=4;return 0;}
		|	SEP read
		;

pol		:	pol sgnterm
			{
				mpoladd(&temp,&tempmon,&temp);
			}
		|	first
			{
				mpoladd(&temp,&tempmon,&temp);
			}
		;


first	:	sgnterm			
		|	unsterm			
		;

sgnterm	:	PLUS unsterm
		|	MINUS unsterm
			{
				mnegate(&(tempmon.coefs[0]));
			}
		;
	
unsterm	:	powprod	
			{
				MFREE(&coef);MSET(1,&coef);
				mpolmonmove(&coef,expo,&tempmon);
				clean1();
			}
		|	NUMBER TIMES powprod
			{
				MFREE(&coef);
			        Gmstrtoul(&coef,numbers[$1],NULL,10);
				free(numbers[$1]);numbers[$1]=NULL;
				mpolmonmove(&coef,expo,&tempmon);
				clean1();
			}
		|	NUMBER SEP powprod
			{
				MFREE(&coef);
				Gmstrtoul(&coef,numbers[$1],NULL,10);
				free(numbers[$1]);numbers[$1]=NULL;
				mpolmonmove(&coef,expo,&tempmon);
				clean1();
			}
		|	NUMBER
			{
				MFREE(&coef);
				Gmstrtoul(&coef,numbers[$1],NULL,10);
				free(numbers[$1]);numbers[$1]=NULL;
				mpolmonmove(&coef,expo,&tempmon);
				clean1();
			}
		;

powprod	:	powprod TIMES power
		|	powprod SEP power
		|	power
		;

power	:	SYMBOL POWER NUMBER
			{
				expo[0]+=(expo[$1+1]+= (short)atoi(numbers[$3]));
				free(numbers[$3]);
				numbers[$3]=NULL;
			}
		|	SYMBOL
			{
				expo[0]+=(expo[$1+1]+=1);
			}
		|	UNKNOWN POWER NUMBER   
		|	UNKNOWN		       
		;

%%

void yyerror(string_t s)          {printf("%s\n",s);}

