%{
#include <string.h>
#include "cmump.h"
#include "multpol.h"
#include "translate_tab.h"

#define NBUF 1000

int id_num(void);
int id_var(void);
extern short nvars;
extern char? varnames[100];

extern MPOL tempmon,temp;
extern MINT coef;
extern short expo[1000];
extern int status;
extern char ?numbers[NBUF];

#define YY_SKIP_YYWRAP
extern int yywrap(void);
%}
/* regular definitions */
%START COMMENT

beg_com \/\*
end_com \*\/
sep_pol	; 
ws	[ \t\n]*
mult    \*
plus	\+
minus	\-
power	\^
letter	[A-Za-z]
digit	[0-9]
symbol	{letter}({letter}|{digit})*
number	({digit})+
%%

{ws}			{return(SEP);}
{ws}?{sep_pol}		{return(STOP); }
{ws}?{mult}{ws}?	{return(TIMES);}
{power}			{return(POWER);}
{symbol}		{int x; if((x = id_var())>=0) { yylval = new Int(x); return(SYMBOL); } else return(UNKNOWN);}
{number}		{int x; if((x = id_num())>=0) { yylval = new Int(x); return(NUMBER); } else return(FULBUF);}
{ws}?{plus}{ws}?	{return(PLUS);}
{ws}?{minus}{ws}?	{return(MINUS);}
{ws}?{beg_com}		{BEGIN COMMENT	;}

<COMMENT>([^\*]|\*[^\/])*	{}
<COMMENT>{end_com}{ws}?		{BEGIN 0;return(SEP);}

%%

int id_var(void)
{
	int i;

	for (i=0;i<nvars;i++){
		if (!strcmp(yytext,varnames[i]))
			return(i);
	}
	/* when it finds an unknown ...*/
	printf("Unknown variable : %s\n",yytext);
	status=3;
	return(-1);
}


int id_num(void)
{
	int i;
	
	for ( i=0; (i<NBUF) && (numbers[i]!=NULL); i++ )
		;
	if (i==NBUF)
		return(-1);
	else {
		/* printf("call malloc: %d\n",sizeof(char)*(yyleng+1)); */
		numbers[i]=new { for i < yyleng+1 : '\0' };
		strncpy(numbers[i],yytext,yyleng);
		numbers[i][yyleng]='\0';
		return(i);
	}
}

int yywrap(void) {
return 0;
}

