#!/usr/bin/perl

if ($#ARGV != 1) {
    die("usage: $0 rawtimes-file hist-prog\n");
}

open(IN, $ARGV[0]) or die "Can't open file $ARGV[0]: $!\n";
open(OUT, "| $ARGV[1]") or die "Can't open pipe to $ARGV[1]: $!\n";

$numvars = 0;
$i = -1;

while (<IN>) {
    ($Fld1,$Fld2) = split(' ');
    if (/^TEST.*$/) {
	$testname = $Fld2;
    }
    elsif (/^VAR.*$*/) {
	$varname[$numvars++] = $Fld2;
    }
    elsif (/^PROG.*$/) {
	if ($i != -1) {
	    $numruns = $i;
	}
	$i = 0;
    }
    else {
	$Time[$numvars - 1][$i] += $Fld1;
	$i++;
    }
}
close(IN);
for ($j = 0; $j < $numvars; $j++) {
    printf OUT '%s ', $varname[$j];

    for ($k = 0; $k < $numruns; $k++) {
	printf OUT '%f ', $Time[$j][$k];
    }
    print OUT "\n";
}
close(OUT);
