#!/usr/bin/perl -w

my $testnum = $ENV{TESTNUM};
   $testnum = 5 unless defined $testnum;
my $testname = $ENV{TESTNAME};

my @filetypes = ('SRCS','HDRS','LEXS','YACCS','NOEXT');

my %cextensions = (SRCS  => '.c',
                   HDRS  => '.h',
                   LEXS  => '.l',
                   YACCS => '.y',
                   NOEXT => ''  );
my %cycextensions = (SRCS  => '.cyc',
                     HDRS  => '.h',
                     LEXS  => '.l',
                     YACCS => '.y',
                     NOEXT => ''  );

my $reportfile = 'report.diff';

# This overwrites the existing file
open(REPORT,">$reportfile") || die "Opening $reportfile";

format REPORT =
  @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<: @<<<<< @<<<<< @<<<<<
  $recname, $total, $fmt_add, $fmt_sub
.

foreach my $j (<cy*>) {
  print REPORT "Diff: $testname $j\n";
  my $running_total = 0;
  my $running_add = 0;
  my $running_sub = 0;
  foreach my $type (@filetypes) {
    if(defined($ENV{$type})) {
      foreach my $i (split(/\s+/,$ENV{$type})) {
        my ($cext,$cycext) = ($cextensions{$type},$cycextensions{$type});
        my $name = "$i$cext.$j.diff";
        $name =~ tr/\//_/;
        system("diff -w c/$i$cext $j/$i$cycext > $name");
        ($total,$add,$sub) = (`wc -l < c/$i$cext`,
                                 `grep '^>' $name | wc -l`,
                                 `grep '^<' $name | wc -l`);
        chomp ($total,$add,$sub);
	$add =~ s/^\s*//;
	$sub =~ s/^\s*//;
	$total =~ s/^\s*//;
	$running_total += $total;
	$running_add += $add;
	$running_sub += $sub;
        $recname = "$i$cext";
	$fmt_add = "+$add";
	$fmt_sub = "-$sub";
	write REPORT;
      }
    }
  }
  $fmt_add = "+$running_add";
  $fmt_sub = "-$running_sub";
  $recname = "Total";
  $total = $running_total;
  write REPORT;
}

close(REPORT);

