package crystal.emitc;

import java.io.*;
import java.util.*;

import crystal.general.*;

public class EmitC {
	
	public static void run(boolean verbose, boolean comments) {
		HashSymtab globals = Symtab.getGlobalScope();
		System.setProperty("line.separator", "\n");

		if (Options.VERBOSITY >= 1)
			System.out.print(verbose ? "\n" : " ... ");
		
		for (Symtab filetab: globals.getKids()) {
			String infile = ((FileSymtab)filetab).getFileName();
			String outfile = adjustSuffix(infile);
				
			PrintStream ps = null;
			try {
				ps = new PrintStream(outfile);
			} catch (FileNotFoundException e) {
		    	System.err.println("File not found: \"" + outfile + "\"");
		    	System.exit(1);
			}

			if (verbose)
				System.out.println("\twriting file \"" + outfile + "\" ...");
	
			if (comments)
				ps.println(
				"/* This file has been automatically generated by Crystal. */\n" +
				"/* Original source file: \"" + infile + "\" */\n");
			
			SymtabPrinter.printGlobal((FileSymtab)filetab, ps, "");

			if (comments)
				ps.println("\n/* File scope starts here. */\n");
			
			SymtabPrinter.printSymtab((HashSymtab)filetab, ps, "");
			ps.println();
						
			for (Function fsym : sortFunctions(Symtab.getFunctions(infile)))
				fsym.printFunction(ps,  fsym.getCFG() != null);
			ps.println();
			ps.close();
		}
		
		SymtabPrinter.checkInit();
		
		if (Options.VERBOSITY >= 1)
			System.out.print(verbose ? "Written all output C files. " : "done. ");	
	}
	
	static List<Function> sortFunctions(Iterable<Function> funs) {
		List<Function> l = new ArrayList<Function>();
		int j = 0;
		for (Function fun : funs) {
			j++;
			int i;
			for (i = 0; i < l.size()-1; i++)
				if (fun.toString().compareTo(l.get(i).toString()) <= 0)
					break;
			l.add(i, fun);
		}
		assert l.size() == j;
		return l;
	}

	public static String adjustSuffix(String file) {
		int i = file.lastIndexOf('.');
		if (i > 0) file = file.substring(0,i);
		return file + ".out.c";
	}
}

