//Autogenerated from crystal/ast/SimplePass.tmpl, DO NOT EDIT!
package crystal.ast;

import crystal.general.HashSymtab;

import java.util.Stack;


/** A helper for implementing passes that only need to visit a 
 *  few nodes --- it takes care of all the subchildren walking; 
 *  and provides do-nothing defaults for localVisit methods. */
public class SimplePass implements 
	StatVisitor<Object,Object>, 
	ExprVisitor<Object,Object>
{
    /** Initiates the recursive walk */
    public void process(Statement s) {
        s.accept(this, null);
    }

    public void process(Expression e) {
        e.accept(this, null);
    }

    /** Returns the parent of the node whose localVisitPre/Post 
     *  method is currently called */
    protected Parent getParent() {
        return parentStack.peek();
    }

    /** Returns the grandparent */
    protected Parent getGrandParent() {
        return parentStack.get(parentStack.size() - 2);
    }

    /** Returns the closest enclosing statement */
    protected Statement getEnclosingStatement() {
        for (int pos = parentStack.size() - 1; pos >= 0; --pos) {
            if (parentStack.get(pos) instanceof Statement)
                return (Statement)parentStack.get(pos);
        }

        return null;
    }

    /** Returns the symbol table for the currently active scope. 
     * Note: do not use this in passes altering which symbol tables 
     * should be active */
    protected HashSymtab activeSymtab() {
        return scopeStack.peek();
    }

    private boolean doChildWalk = true;
    
    /** This may be called from a pre() hook to prevent recursion 
     * through the children */
    protected void abortChildWalk() {
        doChildWalk = false;
    }

    protected void pushParent(Parent node) {
        parentStack.push(node);
    }

    protected void popParent() {
        parentStack.pop();
    }

    private Stack<Parent> parentStack = new Stack<Parent>();
    private Stack<HashSymtab> scopeStack = new Stack<HashSymtab>();

    /** Recursively walks the children and manages the parent and 
     * scope stacks */
    private void recurseThroughChildren(Statement s) {
        if (!doChildWalk) {
            doChildWalk = true;
            return;
        }

        parentStack.push(s);

        for (int child = 0; child < s.numExprKids(); ++child) {
            if (s.getExprKid(child) != null)
                s.getExprKid(child).accept(this, null);
        }

        for (int child = 0; child < s.numStatKids(); ++child) {
            if (s.getStatKid(child) != null)
                s.getStatKid(child).accept(this, null);
        }

        parentStack.pop();
    }

    /** Recursively walks the children and manages the parent stack */
    protected void recurseThroughChildren(Expression e) {
        if (!doChildWalk) {
            doChildWalk = true;
            return;
        }
    
        parentStack.push(e);

        for (int child = 0; child < e.numExprKids(); ++child) {
            if (e.getExprKid(child) != null)
                e.getExprKid(child).accept(this, null);
        }

        for (int child = 0; child < e.numStatKids(); ++child) {
            if (e.getStatKid(child) != null)
                e.getStatKid(child).accept(this, null);
        }

        parentStack.pop();
    }
    

    /** The implementation for BlockStat is special, as it manages 
     * the scope stack */
    public Object visit(BlockStat n, Object o) {
        boolean pushedScope = false;
        if (n.getSymTab() != null) {
            scopeStack.push(n.getSymTab());
            pushedScope = true;
        }
    
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);

        if (pushedScope)
            scopeStack.pop();
        
        return null;
    }

    protected void localVisitPre (BlockStat e) {}
    protected void localVisitPost(BlockStat e) {}

    /* Visit hook for all statements */
    protected void localVisitPre (Statement s) {}
    protected void localVisitPost(Statement s) {}

    /* Visit hook for all expressions */
    protected void localVisitPre (Expression e) {}
    protected void localVisitPost(Expression e) {}


    public Object visit(AddressofExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (AddressofExpr e) {}
    protected void localVisitPost(AddressofExpr e) {}

    public Object visit(ArrayExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (ArrayExpr e) {}
    protected void localVisitPost(ArrayExpr e) {}

    public Object visit(CastExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (CastExpr e) {}
    protected void localVisitPost(CastExpr e) {}

    public Object visit(DerefExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (DerefExpr e) {}
    protected void localVisitPost(DerefExpr e) {}

    public Object visit(FieldExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (FieldExpr e) {}
    protected void localVisitPost(FieldExpr e) {}

    public Object visit(ArithmExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (ArithmExpr e) {}
    protected void localVisitPost(ArithmExpr e) {}

    public Object visit(LogicalExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (LogicalExpr e) {}
    protected void localVisitPost(LogicalExpr e) {}

    public Object visit(CompareExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (CompareExpr e) {}
    protected void localVisitPost(CompareExpr e) {}

    public Object visit(BitwiseExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (BitwiseExpr e) {}
    protected void localVisitPost(BitwiseExpr e) {}

    public Object visit(UnaryArithmExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (UnaryArithmExpr e) {}
    protected void localVisitPost(UnaryArithmExpr e) {}

    public Object visit(NegationExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (NegationExpr e) {}
    protected void localVisitPost(NegationExpr e) {}

    public Object visit(UnaryBitwiseExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (UnaryBitwiseExpr e) {}
    protected void localVisitPost(UnaryBitwiseExpr e) {}

    public Object visit(NumberExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (NumberExpr e) {}
    protected void localVisitPost(NumberExpr e) {}

    public Object visit(SizeofExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (SizeofExpr e) {}
    protected void localVisitPost(SizeofExpr e) {}

    public Object visit(StringExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (StringExpr e) {}
    protected void localVisitPost(StringExpr e) {}

    public Object visit(VarExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (VarExpr e) {}
    protected void localVisitPost(VarExpr e) {}

    public Object visit(AssignExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (AssignExpr e) {}
    protected void localVisitPost(AssignExpr e) {}

    public Object visit(AssignArithmExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (AssignArithmExpr e) {}
    protected void localVisitPost(AssignArithmExpr e) {}

    public Object visit(AssignBitwiseExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (AssignBitwiseExpr e) {}
    protected void localVisitPost(AssignBitwiseExpr e) {}

    public Object visit(AutoIncExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (AutoIncExpr e) {}
    protected void localVisitPost(AutoIncExpr e) {}

    public Object visit(CallExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (CallExpr e) {}
    protected void localVisitPost(CallExpr e) {}

    public Object visit(CommaExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (CommaExpr e) {}
    protected void localVisitPost(CommaExpr e) {}

    public Object visit(ConditionalExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (ConditionalExpr e) {}
    protected void localVisitPost(ConditionalExpr e) {}

    public Object visit(StatExpr n, Object o) {
        localVisitPre((Expression)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Expression)n);
        return null;
    }

    protected void localVisitPre (StatExpr e) {}
    protected void localVisitPost(StatExpr e) {}

    public Object visit(DoWhileStat n, Object o) {
        localVisitPre((Statement)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Statement)n);
        return null;
    }

    protected void localVisitPre (DoWhileStat e) {}
    protected void localVisitPost(DoWhileStat e) {}

    public Object visit(ExprStat n, Object o) {
        localVisitPre((Statement)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Statement)n);
        return null;
    }

    protected void localVisitPre (ExprStat e) {}
    protected void localVisitPost(ExprStat e) {}

    public Object visit(ForStat n, Object o) {
        localVisitPre((Statement)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Statement)n);
        return null;
    }

    protected void localVisitPre (ForStat e) {}
    protected void localVisitPost(ForStat e) {}

    public Object visit(IfStat n, Object o) {
        localVisitPre((Statement)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Statement)n);
        return null;
    }

    protected void localVisitPre (IfStat e) {}
    protected void localVisitPost(IfStat e) {}

    public Object visit(BreakStat n, Object o) {
        localVisitPre((Statement)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Statement)n);
        return null;
    }

    protected void localVisitPre (BreakStat e) {}
    protected void localVisitPost(BreakStat e) {}

    public Object visit(ContinueStat n, Object o) {
        localVisitPre((Statement)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Statement)n);
        return null;
    }

    protected void localVisitPre (ContinueStat e) {}
    protected void localVisitPost(ContinueStat e) {}

    public Object visit(GotoStat n, Object o) {
        localVisitPre((Statement)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Statement)n);
        return null;
    }

    protected void localVisitPre (GotoStat e) {}
    protected void localVisitPost(GotoStat e) {}

    public Object visit(ReturnStat n, Object o) {
        localVisitPre((Statement)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Statement)n);
        return null;
    }

    protected void localVisitPre (ReturnStat e) {}
    protected void localVisitPost(ReturnStat e) {}

    public Object visit(SwitchStat n, Object o) {
        localVisitPre((Statement)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Statement)n);
        return null;
    }

    protected void localVisitPre (SwitchStat e) {}
    protected void localVisitPost(SwitchStat e) {}

    public Object visit(WhileStat n, Object o) {
        localVisitPre((Statement)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Statement)n);
        return null;
    }

    protected void localVisitPre (WhileStat e) {}
    protected void localVisitPost(WhileStat e) {}

    public Object visit(LabelStat n, Object o) {
        localVisitPre((Statement)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Statement)n);
        return null;
    }

    protected void localVisitPre (LabelStat e) {}
    protected void localVisitPost(LabelStat e) {}

    public Object visit(CaseLabelStat n, Object o) {
        localVisitPre((Statement)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Statement)n);
        return null;
    }

    protected void localVisitPre (CaseLabelStat e) {}
    protected void localVisitPost(CaseLabelStat e) {}

    public Object visit(AsmStat n, Object o) {
        localVisitPre((Statement)n);
        localVisitPre(n);
        recurseThroughChildren(n);
        localVisitPost(n);
        localVisitPost((Statement)n);
        return null;
    }

    protected void localVisitPre (AsmStat e) {}
    protected void localVisitPost(AsmStat e) {}
}
