(* util.sml *)

structure Util =
struct

  (* concatenate directory and file names into a path *)
  fun concatP [] = ""
    | concatP [x] = x
    | concatP (x::xs) = OS.Path.concat (x,concatP (xs))

  (* copy a file, changing Unix newline to Windows crlf
   * applied to setup.rul and license.txt *)
  fun copy (from, to) = 
      let val from' = TextIO.openIn (from)
	  val to' = TextIO.openOut (to)
	  fun loop () = 
	      let val line = TextIO.inputLine (from')
	       in case (line) 
		    of "" => ()
		     | s => (TextIO.output (to',String.substring (s,0,size(s)-1));
			     TextIO.output1 (to',#"\r");
			     TextIO.output1 (to',#"\n");
			     loop ())
	      end
          (* val s = TextIO.inputAll (from') *)
       in
          (* TextIO.output (to',s); *)
    loop ();
    TextIO.closeIn (from');
    TextIO.closeOut (to')
  end

  (* simple file copy *)
  fun copy0 (from, to) = 
      let val from' = TextIO.openIn (from)
	  val to' = TextIO.openOut (to)
       in TextIO.output (to',TextIO.inputAll (from'));
	  TextIO.closeIn (from');
	  TextIO.closeOut (to')
      end

end (* structure Util *)
